/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.clientserver;

import java.io.IOException;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.tests.clientserver.DeadLockAddress;
import org.eclipse.persistence.testing.tests.clientserver.DeadLockEmployee;
import org.eclipse.persistence.testing.tests.clientserver.Server;

public class ConcurrentTestRefreshWithOptimisticLocking
extends AutoVerifyTestCase {
    public static int numThreads = 6;
    public boolean isCheckerThread;
    public static Server server;
    public static boolean execute;
    public static Thread[] threadList;
    public static long[] timeList;
    public static long runTime;
    public int index;
    public boolean oldVersionRefresh;

    public ConcurrentTestRefreshWithOptimisticLocking(long runtime) {
        this.setDescription("Test Simulates a highly concurrent situation with refreshing and optimistic locks");
        runTime = runtime;
    }

    protected ConcurrentTestRefreshWithOptimisticLocking(boolean checkerThread, int index) {
        this.isCheckerThread = checkerThread;
        this.index = index;
    }

    public void reset() {
        execute = false;
        for (int count = 0; count < numThreads; ++count) {
            try {
                threadList[count].join();
                continue;
            }
            catch (InterruptedException ex) {
                throw new TestProblemException("Test thread was interrupted.  Test failed to run properly");
            }
        }
        ConcurrentTestRefreshWithOptimisticLocking.server.serverSession.getClassDescriptor(DeadLockEmployee.class).setShouldOnlyRefreshCacheIfNewerVersion(this.oldVersionRefresh);
        server.logout();
    }

    public void setup() {
        execute = true;
        try {
            this.getSession().getLog().write("WARNING, some tests may take 3 minutes or more");
            this.getSession().getLog().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            DatabaseLogin login = (DatabaseLogin)this.getSession().getLogin().clone();
            server = new Server(login, numThreads, numThreads + 2);
            ConcurrentTestRefreshWithOptimisticLocking.server.serverSession.setSessionLog(this.getSession().getSessionLog());
            server.login();
            server.copyDescriptors(this.getSession());
            ClassDescriptor empDesc = ConcurrentTestRefreshWithOptimisticLocking.server.serverSession.getClassDescriptor(DeadLockEmployee.class);
            this.oldVersionRefresh = empDesc.shouldOnlyRefreshCacheIfNewerVersion();
            empDesc.onlyRefreshCacheIfNewerVersion();
        }
        catch (ValidationException ex) {
            this.verify();
        }
        for (int count = 0; count < numThreads; ++count) {
            ConcurrentTestRefreshWithOptimisticLocking.threadList[count] = new Thread(new ConcurrentTestRefreshWithOptimisticLocking(false, count).runnable());
            ConcurrentTestRefreshWithOptimisticLocking.timeList[count] = System.currentTimeMillis();
        }
    }

    public void test() {
        for (int count = 0; count < numThreads; ++count) {
            threadList[count].start();
        }
        Thread checker = new Thread(new ConcurrentTestRefreshWithOptimisticLocking(true, -1).runnable());
        checker.start();
        try {
            checker.join();
        }
        catch (InterruptedException ex) {
            throw new TestProblemException("Test thread was interrupted.  Test failed to run properly");
        }
    }

    public void verify() {
        if (!execute) {
            for (int count = 0; count < numThreads; ++count) {
                threadList[count].stop();
            }
            execute = true;
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            throw new TestErrorException("This test caused a deadlock in TopLink.  see bug 33883838");
        }
    }

    public Runnable runnable() {
        return new Runnable(){

            @Override
            public void run() {
                if (ConcurrentTestRefreshWithOptimisticLocking.this.isCheckerThread) {
                    ConcurrentTestRefreshWithOptimisticLocking.this.watchOtherThreads();
                } else {
                    ConcurrentTestRefreshWithOptimisticLocking.this.executeUntilStopped();
                }
            }
        };
    }

    public void watchOtherThreads() {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < runTime + 30000L && execute) {
            for (int localIdex = 0; localIdex < numThreads; ++localIdex) {
                if (System.currentTimeMillis() - timeList[localIdex] <= 30000L) continue;
                execute = false;
                break;
            }
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException ex) {
                throw new TestProblemException("Test thread was interrupted.  Test failed to run properly");
            }
        }
    }

    public void executeUntilStopped() {
        ReadObjectQuery query;
        ClientSession session = ConcurrentTestRefreshWithOptimisticLocking.server.serverSession.acquireClientSession();
        DeadLockAddress address = (DeadLockAddress)session.readObject(DeadLockAddress.class);
        DeadLockEmployee employee = (DeadLockEmployee)session.readObject(DeadLockEmployee.class);
        if (this.index % 2 != 0) {
            query = new ReadObjectQuery((Object)address);
            query.refreshIdentityMapResult();
            query.setCascadePolicy(3);
        } else {
            query = new ReadObjectQuery((Object)employee);
            query.refreshIdentityMapResult();
            query.setCascadePolicy(3);
        }
        while (execute) {
            ConcurrentTestRefreshWithOptimisticLocking.timeList[this.index] = System.currentTimeMillis();
            session.executeQuery((DatabaseQuery)query);
        }
    }

    static {
        execute = true;
        threadList = new Thread[numThreads];
        timeList = new long[numThreads];
    }
}

