/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.clientserver;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.clientserver.Reader;
import org.eclipse.persistence.testing.tests.clientserver.Server1;
import org.eclipse.persistence.testing.tests.clientserver.StreamReader;

public abstract class ClientServerReadingTest
extends TestCase {
    protected DatabaseLogin login;
    protected Reader[] reader = new Reader[50];
    protected Server1 server;
    private static final int NUM_THREADS = 50;
    int type;
    protected boolean shouldReadFromStreams;

    public ClientServerReadingTest(boolean useStreamReader, int theType) {
        this.setDescription("The test simulates the client/serve by spawning clients in the thread");
        this.shouldReadFromStreams = useStreamReader;
        this.type = theType;
    }

    public void reset() {
        block3: {
            try {
                for (int index = 0; index < 50; ++index) {
                    this.reader[index].release();
                }
                this.server.logout();
                this.getDatabaseSession().logout();
                this.getDatabaseSession().login();
            }
            catch (Exception ex) {
                if (!(ex instanceof ValidationException)) break block3;
                this.verify();
            }
        }
    }

    public void setup() {
        block6: {
            try {
                this.login = (DatabaseLogin)this.getSession().getLogin().clone();
                this.server = new Server1(this);
                this.server.serverSession.setSessionLog(this.getSession().getSessionLog());
                this.server.login();
                this.server.copyDescriptors(this.getSession());
                if (this.shouldReadFromStreams) {
                    for (int index = 0; index < 50; ++index) {
                        this.reader[index] = new StreamReader(this.server, this.getSession());
                    }
                } else {
                    for (int index = 0; index < 50; ++index) {
                        this.reader[index] = new Reader(this.server, this.getSession());
                    }
                }
            }
            catch (Exception ex) {
                if (!(ex instanceof ValidationException)) break block6;
                this.verify();
            }
        }
    }

    public void test() {
        block6: {
            try {
                int index;
                for (index = 0; index < 50; ++index) {
                    this.reader[index].start();
                }
                try {
                    for (index = 0; index < 50; ++index) {
                        this.reader[index].join();
                    }
                }
                catch (InterruptedException exception) {
                    TestErrorException testException = new TestErrorException("Client threads are interrupted");
                    testException.setInternalException((Throwable)exception);
                    throw testException;
                }
            }
            catch (Exception ex) {
                if (!(ex instanceof ValidationException)) break block6;
                this.verify();
            }
        }
    }

    public void verify() {
        try {
            if (this.server.errorOccured) {
                throw new TestErrorException("An error occurred on one of the clients, check System.out.");
            }
        }
        catch (Exception ex) {
            if (!(ex instanceof ValidationException) || ((ValidationException)ex).getErrorCode() == 7090) {
                // empty if block
            }
        }
    }
}

