/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.inheritance;

import java.io.Serializable;
import java.util.Enumeration;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.TransformationMapping;
import org.eclipse.persistence.sessions.DataRecord;
import org.eclipse.persistence.testing.models.inheritance.IBMPC;
import org.eclipse.persistence.testing.models.inheritance.Mac;
import org.eclipse.persistence.testing.models.inheritance.Mainframe;
import org.eclipse.persistence.testing.models.inheritance.PC;
import org.eclipse.persistence.tools.schemaframework.ViewDefinition;

public class Computer
implements Serializable {
    public int id;
    public int memory;
    public int processorSpeed;
    public String processorMake;
    public String manufacturer;

    public static void addToDescriptor(ClassDescriptor descriptor) {
        Enumeration mappings = descriptor.getMappings().elements();
        while (mappings.hasMoreElements()) {
            Object ctype;
            DatabaseMapping mapping = (DatabaseMapping)mappings.nextElement();
            if (!mapping.isTransformationMapping() || (ctype = ((TransformationMapping)mapping).getFieldNameToMethodNames().get("CTYPE")) == null) continue;
            return;
        }
        TransformationMapping typeMapping = new TransformationMapping();
        typeMapping.addFieldTransformation("CTYPE", "getComputerType");
        descriptor.addMapping((DatabaseMapping)typeMapping);
    }

    public static Mac example1() {
        Mac mac = new Mac();
        mac.processorSpeed = 166;
        mac.memory = 64;
        mac.processorMake = "Motorolla 6046";
        mac.manufacturer = "Apple";
        return mac;
    }

    public static IBMPC example2() {
        IBMPC pc = new IBMPC();
        pc.processorSpeed = 133;
        pc.memory = 32;
        pc.processorMake = "Intel Pentium";
        pc.manufacturer = "Dell";
        pc.isClone = "true";
        return pc;
    }

    public static IBMPC example3() {
        IBMPC pc = new IBMPC();
        pc.processorSpeed = 450;
        pc.memory = 128;
        pc.processorMake = "Intel Pentium II";
        pc.manufacturer = "Compact";
        pc.isClone = "true";
        return pc;
    }

    public static IBMPC example3a() {
        IBMPC pc = new IBMPC();
        pc.processorSpeed = 450;
        pc.memory = 128;
        pc.processorMake = "Intel Pentium II";
        pc.manufacturer = "IBM";
        pc.isClone = "false";
        return pc;
    }

    public static PC example4() {
        PC pc = new PC();
        pc.processorSpeed = 33;
        pc.memory = 8;
        pc.processorMake = "Motorolla 3000";
        pc.manufacturer = "Apple";
        return pc;
    }

    public static Mainframe example5() {
        Mainframe mainframe = new Mainframe();
        mainframe.processorSpeed = 5000;
        mainframe.memory = 1600;
        mainframe.processorMake = "R6000";
        mainframe.manufacturer = "IBM";
        mainframe.numberOfProcessors = 12;
        return mainframe;
    }

    public static Class<?> getClassFromRow(DataRecord row) {
        if (row.get((Object)"CTYPE").equals("PC")) {
            if (row.get((Object)"PCTYPE").equals("IBM")) {
                return IBMPC.class;
            }
            if (row.get((Object)"PCTYPE").equals("MAC")) {
                return Mac.class;
            }
            return PC.class;
        }
        if (row.get((Object)"CTYPE").equals("MF")) {
            return Mainframe.class;
        }
        return Computer.class;
    }

    public String getComputerType() {
        return "COM";
    }

    public static ViewDefinition oracleView() {
        ViewDefinition definition = new ViewDefinition();
        definition.setName("AllComputers");
        definition.setSelectClause("Select C.*, M.* from INH_COMP C, INH_MF M where C.id = M.MF_ID (+)");
        return definition;
    }

    public static ViewDefinition sybaseView() {
        ViewDefinition definition = new ViewDefinition();
        definition.setName("AllComputers");
        definition.setSelectClause("Select C.*, M.* from INH_COMP C, INH_MF M where C.ID *= M.MF_ID");
        return definition;
    }

    public static ViewDefinition mySQLView() {
        ViewDefinition definition = new ViewDefinition();
        definition.setName("AllComputers");
        definition.setSelectClause("Select C.*, M.* from INH_COMP C left join INH_MF M on C.ID = M.MF_ID");
        return definition;
    }
}

