/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.aggregate;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.testing.models.aggregate.Customer;
import org.eclipse.persistence.testing.models.aggregate.House;
import org.eclipse.persistence.testing.models.aggregate.SingleHouse;
import org.eclipse.persistence.testing.models.aggregate.TownHouse;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class Agent
implements Serializable {
    private String firstName;
    private String lastName;
    private BigDecimal id;
    private ValueHolderInterface<Vector<House>> houses = new ValueHolder(new Vector());
    private List houses2 = new ArrayList(2);
    private ValueHolderInterface<Vector<Customer>> customers = new ValueHolder(new Vector());

    public void addCustomer(Customer customer) {
        this.getCustomers().addElement(customer);
    }

    public void addHouse(House house) {
        this.getHouses().addElement(house);
    }

    public static void addToDescriptor(ClassDescriptor descriptor) {
        OneToManyMapping houses = (OneToManyMapping)descriptor.getMappingForAttributeName("houses");
        houses.useTransparentCollection();
    }

    public static Agent example1() {
        Agent example1 = new Agent();
        example1.setFirstName("Micheal");
        example1.setLastName("Jordan");
        Vector<Customer> customers = new Vector<Customer>();
        customers.addElement(Customer.example1());
        customers.addElement(Customer.example2());
        example1.setCustomers(customers);
        Vector<House> houses = new Vector<House>();
        houses.addElement(SingleHouse.example1());
        houses.addElement(TownHouse.example3());
        example1.setHouses(houses);
        return example1;
    }

    public static Agent example2() {
        Agent example2 = new Agent();
        example2.setFirstName("Dennis");
        example2.setLastName("Rodman");
        Vector<Customer> customers = new Vector<Customer>();
        customers.addElement(Customer.example3());
        example2.setCustomers(customers);
        Vector<House> houses = new Vector<House>();
        houses.addElement(SingleHouse.example2());
        houses.addElement(TownHouse.example4());
        example2.setHouses(houses);
        return example2;
    }

    public Vector<Customer> getCustomers() {
        return (Vector)this.getCustomerValueHolder().getValue();
    }

    public ValueHolderInterface<Vector<Customer>> getCustomerValueHolder() {
        return this.customers;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public Vector<House> getHouses() {
        return (Vector)this.getHouseValueHolder().getValue();
    }

    public List getHouses2() {
        return this.houses2;
    }

    public ValueHolderInterface<Vector<House>> getHouseValueHolder() {
        return this.houses;
    }

    public BigDecimal getId() {
        return this.id;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void removeCustomer(Customer customer) {
        this.getCustomers().removeElement(customer);
    }

    public void removeHouse(House house) {
        this.getHouses().removeElement(house);
    }

    public void setCustomers(Vector<Customer> customerVector) {
        this.customers.setValue(customerVector);
    }

    public void setCustomerValueHolder(ValueHolderInterface<Vector<Customer>> customers) {
        this.customers = customers;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setHouses(Vector<House> houseVector) {
        this.getHouseValueHolder().setValue(houseVector);
    }

    public void setHouses2(List newHouses2) {
        this.houses2 = newHouses2;
    }

    public void setHouseValueHolder(ValueHolderInterface<Vector<House>> houses) {
        this.houses = houses;
    }

    public void setId(BigDecimal id) {
        this.id = id;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public static TableDefinition tableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName("AGENT");
        definition.addIdentityField("AGENT_ID", BigDecimal.class, 15);
        definition.addField("FNAME", String.class, 30);
        definition.addField("LNAME", String.class, 30);
        definition.addField("VERSION", BigDecimal.class, 15);
        return definition;
    }
}

