/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.dynamic;

import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.spi.PersistenceProvider;
import jakarta.persistence.spi.PersistenceUnitInfo;
import jakarta.persistence.spi.ProviderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.deployment.xml.parser.PersistenceContentHandler;
import org.eclipse.persistence.internal.jpa.deployment.xml.parser.XMLExceptionHandler;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCaseHelper;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class DynamicTestHelper {
    public static final String DYNAMIC_PERSISTENCE_NAME = "dynamic";
    static final String DYNAMIC_PERSISTENCE_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><persistence version=\"1.0\" xmlns=\"http://java.sun.com/xml/ns/persistence\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/persistence http://java.sun.com/xml/ns/persistence/persistence_1_0.xsd\"><persistence-unit name=\"dynamic\" transaction-type=\"RESOURCE_LOCAL\"><exclude-unlisted-classes>true</exclude-unlisted-classes></persistence-unit></persistence>";
    static URL dynamicTestUrl = null;

    public static EntityManagerFactory createEMF(String emName) {
        PersistenceContentHandler myContentHandler = new PersistenceContentHandler();
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser sp = spf.newSAXParser();
            XMLReader xmlReader = sp.getXMLReader();
            XMLExceptionHandler xmlErrorHandler = new XMLExceptionHandler();
            xmlReader.setErrorHandler((ErrorHandler)xmlErrorHandler);
            xmlReader.setContentHandler((ContentHandler)myContentHandler);
            InputSource inputSource = new InputSource(new StringReader(DYNAMIC_PERSISTENCE_XML));
            xmlReader.parse(inputSource);
        }
        catch (Exception e) {
            return null;
        }
        final SEPersistenceUnitInfo puInfo = (SEPersistenceUnitInfo)myContentHandler.getPersistenceUnits().get(0);
        puInfo.setPersistenceUnitRootUrl(dynamicTestUrl);
        PersistenceProvider provider = new PersistenceProvider(){

            public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map map) {
                return null;
            }

            public EntityManagerFactory createEntityManagerFactory(String emName, Map map) {
                if (emName.equals(puInfo.getPersistenceUnitName())) {
                    EntityManagerSetupImpl entityManagerSetupImpl = new EntityManagerSetupImpl(DynamicTestHelper.DYNAMIC_PERSISTENCE_NAME, DynamicTestHelper.DYNAMIC_PERSISTENCE_NAME);
                    map.put("eclipselink.weaving", "static");
                    puInfo.getProperties().put("eclipselink.exclude-eclipselink-orm", "true");
                    entityManagerSetupImpl.predeploy((PersistenceUnitInfo)puInfo, map);
                    return new EntityManagerFactoryImpl(entityManagerSetupImpl, map);
                }
                return null;
            }

            public ProviderUtil getProviderUtil() {
                return null;
            }

            public void generateSchema(PersistenceUnitInfo info, Map map) {
            }

            public boolean generateSchema(String persistenceUnitName, Map map) {
                return false;
            }
        };
        return provider.createEntityManagerFactory(emName, JUnitTestCaseHelper.getDatabaseProperties());
    }

    static {
        try {
            dynamicTestUrl = new URL(null, "inmemory:", new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL url) throws IOException {
                    return new URLConnection(url){

                        @Override
                        public InputStream getInputStream() throws IOException {
                            return null;
                        }

                        @Override
                        public void connect() throws IOException {
                        }
                    };
                }
            });
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }
}

