/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.ModelExamples;
import org.eclipse.persistence.testing.models.jpa.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.advanced.PhoneNumberPK;
import org.eclipse.persistence.testing.tests.jpa.EntityContainerTestBase;

public class EMCascadingRemoveAndFlushTest
extends EntityContainerTestBase {
    public Integer[] empIDs = new Integer[2];
    public HashMap persistedItems = new HashMap(4);
    public ArrayList<PhoneNumberPK> phoneIDs = new ArrayList();

    public EMCascadingRemoveAndFlushTest() {
        this.setDescription("Test cascading remove and flush in EntityManager");
    }

    @Override
    public void setup() {
        super.setup();
        this.phoneIDs.clear();
        this.persistedItems.clear();
        Employee employee = ModelExamples.employeeExample1();
        employee.addPhoneNumber(ModelExamples.phoneExample4());
        employee.addPhoneNumber(ModelExamples.phoneExample8());
        try {
            this.beginTransaction();
            this.getEntityManager().persist((Object)employee);
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            ex.printStackTrace();
            throw new TestErrorException("Exception thrown durring persist and flush" + ex);
        }
        this.empIDs[0] = employee.getId();
    }

    public void test() {
        try {
            this.beginTransaction();
            Employee employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]);
            Iterator phones = employee.getPhoneNumbers().iterator();
            while (phones.hasNext()) {
                this.phoneIDs.add(((PhoneNumber)phones.next()).buildPK());
            }
            this.getEntityManager().remove((Object)employee);
            this.getEntityManager().flush();
            ((JpaEntityManager)this.getEntityManager()).getServerSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            this.getEntityManager().clear();
            this.persistedItems.put("after flush Employee", this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]));
            Iterator<PhoneNumberPK> ids = this.phoneIDs.iterator();
            while (ids.hasNext()) {
                PhoneNumber phone = (PhoneNumber)this.getEntityManager().find(PhoneNumber.class, (Object)ids.next());
                if (phone == null) continue;
                this.persistedItems.put("after flush PhoneNumber", phone);
            }
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            ex.printStackTrace();
            throw new TestErrorException("Exception thrown durring persist and flush" + ex);
        }
    }

    public void verify() {
        if (this.persistedItems.get("after flush Employee") != null) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " was not deleted");
        }
        if (this.persistedItems.get("after flush PhoneNumber") != null) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " a phone number was not deleted");
        }
    }
}

