/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.workbenchintegration;

import java.io.File;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.PessimisticLockingPolicy;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.factories.ProjectClassGenerator;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;
import org.eclipse.persistence.testing.tests.workbenchintegration.Compiler;

public class ProjectClassGeneratorWithCMPDescriptorTest
extends AutoVerifyTestCase {
    Project project;
    Project generatedProject;
    boolean foundException;
    String projectShortClassName = "ProjectClassGeneratorWithCMPDescriptorTestProject";

    public ProjectClassGeneratorWithCMPDescriptorTest() {
        this.setDescription("Test if ProjectTestGenerator generates a correct project when a CMP Descriptor is used.");
    }

    public static void main(String[] args) {
        ProjectClassGeneratorWithCMPDescriptorTest test = new ProjectClassGeneratorWithCMPDescriptorTest();
        test.setup();
        test.test();
        test.verify();
        test.reset();
    }

    public void reset() {
        File file = new File(this.projectShortClassName + ".java");
        file.delete();
        file = new File(this.projectShortClassName + ".class");
        file.delete();
    }

    protected void setup() {
        this.project = new EmployeeProject();
        CMPPolicy cmpPolicy = new CMPPolicy();
        cmpPolicy.setPessimisticLockingPolicy(new PessimisticLockingPolicy());
        cmpPolicy.setDeferModificationsUntilCommit(5);
        cmpPolicy.setForceUpdate(true);
        cmpPolicy.setNonDeferredCreateTime(1000);
        cmpPolicy.setUpdateAllFields(true);
        cmpPolicy.setPessimisticLockingPolicy(new PessimisticLockingPolicy());
        cmpPolicy.getPessimisticLockingPolicy().setLockingMode((short)2);
        this.project.getDescriptor(Address.class).setCMPPolicy(cmpPolicy);
    }

    public void test() {
        String fileName = this.projectShortClassName + ".java";
        try {
            ProjectClassGenerator.write((Project)this.project, (String)this.projectShortClassName, (String)fileName);
        }
        catch (Exception e) {
            throw new TestErrorException("Falied to generate project file " + fileName, (Throwable)e);
        }
        try {
            boolean result = Compiler.compile(fileName);
            if (!result) {
                throw new TestErrorException("Failed to compiled the generated project file " + fileName + ". This could either be a legitimate compile failure, or could result if you do not have the tools.jar from your JDK on the classpath.");
            }
            Class<?> projectClass = Class.forName(this.projectShortClassName);
            this.generatedProject = (Project)projectClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new TestErrorException("Failed obtain new project instance from the generated and compiled project.  It may be possible to solve this issue by adding the tools.jar from your JDK to the classpath.", (Throwable)exception);
        }
    }

    protected void verify() {
        CMPPolicy cmpPolicy = this.project.getDescriptor(Address.class).getCMPPolicy();
        CMPPolicy generatedCMPPolicy = this.generatedProject.getDescriptor(Address.class).getCMPPolicy();
        String errors = new String();
        if (generatedCMPPolicy == null) {
            errors = errors + "CMPPolicy is null.\n";
        } else {
            if (generatedCMPPolicy.getDeferModificationsUntilCommit() != cmpPolicy.getDeferModificationsUntilCommit()) {
                errors = errors + "CMPPolicy: deferModificationsUntilCommit setting is not the same.\n";
            }
            if (generatedCMPPolicy.getForceUpdate() != cmpPolicy.getForceUpdate()) {
                errors = errors + "CMPPolicy: forceUpdate setting is not the same.\n";
            }
            if (generatedCMPPolicy.getNonDeferredCreateTime() != cmpPolicy.getNonDeferredCreateTime()) {
                errors = errors + "CMPPolicy: nonDeferredCreateTime setting is not the same.\n";
            }
            if (generatedCMPPolicy.getUpdateAllFields() != cmpPolicy.getUpdateAllFields()) {
                errors = errors + "CMPPolicy: updateAllFields setting is not the same.\n";
            }
            if (generatedCMPPolicy.getPessimisticLockingPolicy() == null) {
                errors = errors + "CMPPolicy: pessimistic locking policy is null\n";
            } else if (generatedCMPPolicy.getPessimisticLockingPolicy().getLockingMode() != cmpPolicy.getPessimisticLockingPolicy().getLockingMode()) {
                errors = errors + "PessimisticLockingPolicy: locking mode is not the same\n";
            }
        }
        if (errors.length() > 0) {
            throw new TestErrorException("The following settings of the generated project instance does not have the expected value:\n" + errors);
        }
    }
}

