/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.tests.validation.EmployeeWithProblems;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class NoAttributeValueConversionToFieldValueProvidedTest
extends ExceptionTest {
    ClassDescriptor orgDescriptor;
    IntegrityChecker orgIntegrityChecker;

    public NoAttributeValueConversionToFieldValueProvidedTest() {
        this.setDescription("This tests No Attribute Value Conversion To Field Value Provided (TL-ERROR 115) ");
    }

    protected void setup() {
        this.expectedException = DescriptorException.noAttributeValueConversionToFieldValueProvided(null, null);
        this.orgDescriptor = this.getSession().getDescriptor(EmployeeWithProblems.class);
        this.orgIntegrityChecker = this.getSession().getIntegrityChecker();
        this.getSession().setIntegrityChecker(new IntegrityChecker());
        this.getSession().getIntegrityChecker().dontCatchExceptions();
        ((DatabaseSession)this.getSession()).addDescriptor((ClassDescriptor)this.descriptor());
    }

    @Override
    public void reset() {
        this.getSession().getDescriptors().remove(EmployeeWithProblems.class);
        if (this.orgDescriptor != null) {
            ((DatabaseSession)this.getSession()).addDescriptor(this.orgDescriptor);
        }
        if (this.orgIntegrityChecker != null) {
            this.getSession().setIntegrityChecker(this.orgIntegrityChecker);
        }
    }

    public void test() {
        Object employee = this.getSession().readObject(EmployeeWithProblems.class);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        EmployeeWithProblems employeeClone = (EmployeeWithProblems)uow.registerObject(employee);
        employeeClone.setGender("Other");
        try {
            uow.commit();
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }

    public RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(EmployeeWithProblems.class);
        descriptor.addTableName("EMPLOYEE");
        descriptor.addPrimaryKeyFieldName("EMPLOYEE.EMP_ID");
        descriptor.useFullIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteFullIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping genderMapping = new DirectToFieldMapping();
        genderMapping.setAttributeName("gender");
        genderMapping.setFieldName("EMPLOYEE.GENDER");
        ObjectTypeConverter genderConverter = new ObjectTypeConverter();
        genderConverter.addConversionValue((Object)"M", (Object)"Male");
        genderConverter.addConversionValue((Object)"F", (Object)"Female");
        genderMapping.setConverter((Converter)genderConverter);
        descriptor.addMapping((DatabaseMapping)genderMapping);
        return descriptor;
    }
}

