/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.testing.tests.validation.EmployeeWithProblems;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class MissingMappingForFieldTest
extends ExceptionTest {
    public MissingMappingForFieldTest() {
        this.setDescription("This tests Missing Mapping For Field (TL-ERROR 45)");
    }

    protected void setup() {
        this.expectedException = DescriptorException.missingMappingForField(null, null);
    }

    public void test() {
        RelationalDescriptor descriptor = this.descriptor();
        EmployeeWithProblems person = new EmployeeWithProblems();
        OneToOneMapping dMapping = (OneToOneMapping)descriptor.getMappingForAttributeName("manager");
        DatabaseField dField = (DatabaseField)dMapping.getForeignKeyFields().firstElement();
        descriptor.getObjectBuilder().getMappingsByField().remove(dField);
        try {
            descriptor.getObjectBuilder().extractValueFromObjectForField((Object)person, dField, (AbstractSession)this.getSession());
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }

    public RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(EmployeeWithProblems.class);
        descriptor.addTableName("EMPLOYEE");
        descriptor.addPrimaryKeyFieldName("EMPLOYEE.EMP_ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("EMP_ID");
        descriptor.setSequenceNumberName("EMP_SEQ");
        descriptor.setAlias("EMPLOYEE");
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        OneToOneMapping managerMapping = new OneToOneMapping();
        managerMapping.setAttributeName("manager");
        managerMapping.setReferenceClass(EmployeeWithProblems.class);
        managerMapping.useBasicIndirection();
        managerMapping.addForeignKeyFieldName("EMPLOYEE.MANAGER_ID", "EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)managerMapping);
        return descriptor;
    }
}

