/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class MissingForeignKeyTranslationTest
extends ExceptionTest {
    IntegrityChecker orgIntegrityChecker;

    public MissingForeignKeyTranslationTest() {
        this.setDescription("This tests Missing Foreign Key Translation (TL-ERROR 155)");
    }

    protected void setup() {
        this.expectedException = DescriptorException.missingForeignKeyTranslation(null, null);
        this.orgIntegrityChecker = this.getSession().getIntegrityChecker();
        this.getSession().setIntegrityChecker(new IntegrityChecker());
        this.getSession().getIntegrityChecker().dontCatchExceptions();
    }

    @Override
    public void reset() {
        if (this.orgIntegrityChecker != null) {
            this.getSession().setIntegrityChecker(this.orgIntegrityChecker);
        }
    }

    public void test() {
        OneToOneMapping mapping = new OneToOneMapping();
        RelationalDescriptor descriptor = new RelationalDescriptor();
        mapping.setDescriptor((ClassDescriptor)descriptor);
        mapping.setIsForeignKeyRelationship(false);
        descriptor.setPrimaryKeyFieldName("id");
        try {
            mapping.getOrderedForeignKeyFields();
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }
}

