/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.util.Collection;
import java.util.Vector;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.models.insurance.Claim;
import org.eclipse.persistence.testing.models.insurance.HealthClaim;
import org.eclipse.persistence.testing.models.insurance.HouseClaim;
import org.eclipse.persistence.testing.models.insurance.PolicyHolder;
import org.eclipse.persistence.testing.models.insurance.VehicleClaim;
import org.eclipse.persistence.testing.tests.remote.RemoteModel;

public class NoIdentityTest
extends TransactionalTestCase {
    protected PolicyHolder objectToBeWritten;

    public NoIdentityTest() {
        this.setDescription("Test that the unit of work still works when object identity is lost.");
    }

    public void reset() {
        super.reset();
        if (this.getSession() instanceof RemoteSession) {
            RemoteModel.getServerSession().getDescriptor(Claim.class).getQueryManager().checkCacheForDoesExist();
            RemoteModel.getServerSession().getDescriptor(Claim.class).useFullIdentityMap();
            RemoteModel.getServerSession().getDescriptor(PolicyHolder.class).getQueryManager().checkCacheForDoesExist();
            RemoteModel.getServerSession().getDescriptor(PolicyHolder.class).useFullIdentityMap();
        }
        this.getSession().getDescriptor(Claim.class).getQueryManager().checkCacheForDoesExist();
        this.getSession().getDescriptor(Claim.class).useFullIdentityMap();
        this.getSession().getDescriptor(PolicyHolder.class).getQueryManager().checkCacheForDoesExist();
        this.getSession().getDescriptor(PolicyHolder.class).useFullIdentityMap();
    }

    public void setup() {
        super.setup();
        if (this.getSession() instanceof RemoteSession) {
            RemoteModel.getServerSession().getDescriptor(Claim.class).getQueryManager().checkDatabaseForDoesExist();
            RemoteModel.getServerSession().getDescriptor(Claim.class).useCacheIdentityMap();
            RemoteModel.getServerSession().getDescriptor(PolicyHolder.class).getQueryManager().checkDatabaseForDoesExist();
            RemoteModel.getServerSession().getDescriptor(PolicyHolder.class).useCacheIdentityMap();
        }
        this.getSession().getDescriptor(Claim.class).getQueryManager().checkDatabaseForDoesExist();
        this.getSession().getDescriptor(HealthClaim.class).getQueryManager().checkDatabaseForDoesExist();
        this.getSession().getDescriptor(VehicleClaim.class).getQueryManager().checkDatabaseForDoesExist();
        this.getSession().getDescriptor(HouseClaim.class).getQueryManager().checkDatabaseForDoesExist();
        this.getSession().getDescriptor(Claim.class).useCacheIdentityMap();
        this.getSession().getDescriptor(PolicyHolder.class).getQueryManager().checkDatabaseForDoesExist();
        this.getSession().getDescriptor(PolicyHolder.class).useCacheIdentityMap();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        Vector claims = this.getSession().readAllObjects(Claim.class);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.registerAllObjects((Collection)claims);
        uow.readAllObjects(PolicyHolder.class);
        this.objectToBeWritten = (PolicyHolder)uow.readAllObjects(PolicyHolder.class).firstElement();
        this.objectToBeWritten.setAddress(null);
        uow.commit();
    }

    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        Object objectFromDatabase = this.getSession().readObject((Object)this.objectToBeWritten);
        if (!this.compareObjects(this.objectToBeWritten, objectFromDatabase)) {
            throw new TestErrorException("The object inserted into the database, '" + objectFromDatabase + "' does not match the original, '" + this.objectToBeWritten + ".");
        }
    }
}

