/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.returning.model;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.ReturningPolicy;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.tests.returning.model.AdapterWithReturnObjectControl;
import org.eclipse.persistence.testing.tests.returning.model.Class1;

public class AdapterForReturningProject
extends AdapterWithReturnObjectControl {
    Hashtable insertInfos = new Hashtable();
    Hashtable updateInfos = new Hashtable();

    public void addInsert(String qualifiedName, Object value) {
        DatabaseField field = new DatabaseField(qualifiedName);
        field.setType(BigDecimal.class);
        this.insertInfos.put(field, new InsertInfo(false, false, false, value));
    }

    public void addInsert(String qualifiedName, Object value, boolean overrideNullOnly) {
        DatabaseField field = new DatabaseField(qualifiedName);
        field.setType(BigDecimal.class);
        this.insertInfos.put(field, new InsertInfo(false, false, overrideNullOnly, value));
    }

    public void addInsertReadOnly(String qualifiedName, Object value) {
        DatabaseField field = new DatabaseField(qualifiedName);
        field.setType(BigDecimal.class);
        this.insertInfos.put(field, new InsertInfo(false, false, false, value));
    }

    public void addInsertSequence(String qualifiedName) {
        DatabaseField field = new DatabaseField(qualifiedName);
        field.setType(BigDecimal.class);
        this.insertInfos.put(field, new InsertInfo(false, true, false, new BigDecimal(0)));
    }

    public void addInsertSequenceReadOnly(String qualifiedName) {
        DatabaseField field = new DatabaseField(qualifiedName);
        field.setType(BigDecimal.class);
        this.insertInfos.put(field, new InsertInfo(true, true, false, new BigDecimal(0)));
    }

    public void addUpdate(String qualifiedName, Object value) {
        DatabaseField field = new DatabaseField(qualifiedName);
        field.setType(BigDecimal.class);
        this.updateInfos.put(field, new UpdateInfo(false, value));
    }

    public void addUpdate(String qualifiedName, Object value, boolean overrideNullOnly) {
        DatabaseField field = new DatabaseField(qualifiedName);
        field.setType(BigDecimal.class);
        this.updateInfos.put(field, new UpdateInfo(overrideNullOnly, value));
    }

    @Override
    public void updateProject(Project project, Session session) {
        ClassDescriptor desc = project.getClassDescriptor(Class1.class);
        if (!desc.hasReturningPolicy()) {
            desc.setReturningPolicy(new ReturningPolicy());
        }
        Enumeration insertFields = this.insertInfos.keys();
        while (insertFields.hasMoreElements()) {
            DatabaseField field = (DatabaseField)insertFields.nextElement();
            InsertInfo info = (InsertInfo)this.insertInfos.get(field);
            if (info.isReadOnly) {
                desc.getReturningPolicy().addFieldForInsertReturnOnly(field);
                continue;
            }
            desc.getReturningPolicy().addFieldForInsert(field);
        }
        Enumeration updateFields = this.updateInfos.keys();
        while (updateFields.hasMoreElements()) {
            DatabaseField field = (DatabaseField)updateFields.nextElement();
            UpdateInfo info = (UpdateInfo)this.updateInfos.get(field);
            desc.getReturningPolicy().addFieldForUpdate(field);
        }
    }

    @Override
    public void updateDatabase(Session session) {
        this.createSequence(session);
        this.createInsertTrigger(session);
        this.createUpdateTriggers(session);
    }

    protected void createSequence(Session session) {
        Enumeration insertFields = this.insertInfos.keys();
        while (insertFields.hasMoreElements()) {
            DatabaseField field = (DatabaseField)insertFields.nextElement();
            InsertInfo info = (InsertInfo)this.insertInfos.get(field);
            if (!info.isSequence) continue;
            String seqName = field.getTableName() + "_" + field.getName() + "_SEQ";
            try {
                session.executeNonSelectingCall((Call)new SQLCall("DROP SEQUENCE " + seqName));
            }
            catch (Exception exception) {
                // empty catch block
            }
            session.executeNonSelectingCall((Call)new SQLCall("CREATE SEQUENCE " + seqName));
        }
    }

    protected void createInsertTrigger(Session session) {
        StringWriter writer = new StringWriter();
        writer.write("CREATE OR REPLACE TRIGGER RETURNING_TRIGGER_INS BEFORE INSERT ON RETURNING FOR EACH ROW ");
        writer.write("BEGIN\n");
        Enumeration insertFields = this.insertInfos.keys();
        while (insertFields.hasMoreElements()) {
            DatabaseField field = (DatabaseField)insertFields.nextElement();
            InsertInfo info = (InsertInfo)this.insertInfos.get(field);
            if (info.overrideNullOnly) {
                writer.write("  IF :new." + field.getName() + " IS NULL THEN\n  ");
            }
            if (info.isSequence) {
                String seqName = field.getTableName() + "_" + field.getName() + "_SEQ";
                writer.write("  SELECT " + seqName + ".NEXTVAL INTO :new." + field.getName() + " FROM DUAL;\n");
            } else if (info.value == null) {
                writer.write("  :new." + field.getName() + " := null;\n");
            } else {
                writer.write("  :new." + field.getName() + " := " + info.value + ";\n");
            }
            if (!info.overrideNullOnly) continue;
            writer.write("  END IF;\n");
        }
        writer.write("END;");
        String str = writer.toString();
        DataModifyQuery query = new DataModifyQuery((Call)new SQLCall(str));
        query.setShouldBindAllParameters(false);
        session.executeQuery((DatabaseQuery)query);
    }

    protected void createUpdateTriggers(Session session) {
        Enumeration updateFields = this.updateInfos.keys();
        while (updateFields.hasMoreElements()) {
            DatabaseField field = (DatabaseField)updateFields.nextElement();
            UpdateInfo info = (UpdateInfo)this.updateInfos.get(field);
            this.createUpdateTrigger(session, field, info);
        }
    }

    protected void createUpdateTrigger(Session session, DatabaseField field, UpdateInfo info) {
        StringWriter writer = new StringWriter();
        writer.write("CREATE OR REPLACE TRIGGER RETURNING_TRIGGER_UPD_" + field.getName() + "  BEFORE UPDATE OF " + field.getName() + " ON RETURNING FOR EACH ROW ");
        writer.write("BEGIN\n");
        if (info.overrideNullOnly) {
            writer.write("  IF :new." + field.getName() + " IS NULL THEN\n  ");
        }
        if (info.value == null) {
            writer.write("  :new." + field.getName() + " := null;\n");
        } else {
            writer.write("  :new." + field.getName() + " := " + info.value + ";\n");
        }
        if (info.overrideNullOnly) {
            writer.write("  END IF;\n");
        }
        writer.write("END;");
        String str = writer.toString();
        DataModifyQuery query = new DataModifyQuery((Call)new SQLCall(str));
        query.setShouldBindAllParameters(false);
        session.executeQuery((DatabaseQuery)query);
    }

    @Override
    protected Record getRowForInsert(Record rowToInsert) {
        DatabaseRecord row = new DatabaseRecord();
        Enumeration insertFields = this.insertInfos.keys();
        while (insertFields.hasMoreElements()) {
            DatabaseField field = (DatabaseField)insertFields.nextElement();
            InsertInfo info = (InsertInfo)this.insertInfos.get(field);
            Object valueIn = rowToInsert.get((Object)field);
            if (info.overrideNullOnly && valueIn != null) continue;
            row.put((Object)field, info.value);
        }
        return row;
    }

    @Override
    protected Record getRowForUpdate(Record rowChange) {
        DatabaseRecord row = new DatabaseRecord();
        Enumeration updateFields = this.updateInfos.keys();
        while (updateFields.hasMoreElements()) {
            DatabaseField field = (DatabaseField)updateFields.nextElement();
            UpdateInfo info = (UpdateInfo)this.updateInfos.get(field);
            if (!rowChange.containsKey((Object)field)) continue;
            Object valueIn = rowChange.get((Object)field);
            if (info.overrideNullOnly && valueIn != null) continue;
            row.put((Object)field, info.value);
        }
        return row;
    }

    static class UpdateInfo {
        boolean overrideNullOnly;
        Object value;

        UpdateInfo(boolean overrideNullOnly, Object value) {
            this.overrideNullOnly = overrideNullOnly;
            this.value = value;
        }
    }

    static class InsertInfo {
        boolean isReadOnly;
        boolean isSequence;
        boolean overrideNullOnly;
        Object value;

        InsertInfo(boolean isReadOnly, boolean isSequence, boolean overrideNullOnly, Object value) {
            this.isReadOnly = isReadOnly;
            this.isSequence = isSequence;
            this.overrideNullOnly = overrideNullOnly;
            this.value = value;
        }
    }
}

