/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.insurance.Claim;
import org.eclipse.persistence.testing.models.insurance.HealthClaim;

public class DeepDeleteTest
extends AutoVerifyTestCase {
    protected Claim claim;

    protected void setup() {
        this.beginTransaction();
        this.claim = (Claim)this.getSession().readObject(HealthClaim.class);
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.rollbackTransaction();
    }

    public void test() {
        DeleteObjectQuery query = new DeleteObjectQuery();
        query.setObject((Object)this.claim);
        query.cascadeAllParts();
        this.getSession().executeQuery((DatabaseQuery)query);
    }

    protected void verify() {
        if (this.getSession().readObject((Object)this.claim) != null) {
            throw new TestErrorException("The private delete test failed.  The private owned relationship was not deleted");
        }
        if (this.getSession().readObject((Object)this.claim.getPolicy()) != null) {
            throw new TestErrorException("The private delete test failed.  The private owned relationship was not deleted");
        }
        if (this.getSession().readObject((Object)this.claim.getPolicy().getPolicyHolder()) != null) {
            throw new TestErrorException("The private delete test failed.  The private owned relationship was not deleted");
        }
        if (this.getSession().readObject((Object)this.claim.getPolicy().getPolicyHolder().getAddress()) != null) {
            throw new TestErrorException("The private delete test failed.  The private owned relationship was not deleted");
        }
    }
}

