/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Collection;
import java.util.Map;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.ReadAllTest;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class CollectionReadAllTest
extends ReadAllTest {
    protected Object dbContainter;

    public CollectionReadAllTest(Class referenceClass, int originalObjectsSize, ReadAllQuery query) {
        super(referenceClass, originalObjectsSize);
        this.setQuery(query);
        this.setName("CollectionReadAllTest(" + Helper.getShortClassName((Class)this.getQuery().getContainerPolicy().getContainerClass()) + "," + Helper.getShortClassName((Class)referenceClass) + ")");
    }

    protected int numElements(Object container) {
        if (Helper.classImplementsInterface(container.getClass(), Collection.class)) {
            return ((Collection)container).size();
        }
        if (Helper.classImplementsInterface(container.getClass(), Map.class)) {
            return ((Map)container).size();
        }
        return -1;
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    protected void test() {
        this.dbContainter = this.getSession().executeQuery((DatabaseQuery)this.getQuery());
    }

    protected void verify() {
        Class queryContainerClass = this.getQuery().getContainerPolicy().getContainerClass();
        if (!queryContainerClass.isInstance(this.dbContainter)) {
            throw new TestErrorException("The container class returned was" + this.dbContainter.getClass().toString() + " we expected a " + queryContainerClass.toString() + " to be returned.");
        }
        int objectsFromDatabaseSize = this.numElements(this.dbContainter);
        if (this.getOriginalObjectsSize() != objectsFromDatabaseSize) {
            throw new TestErrorException(objectsFromDatabaseSize + " objects were read from the database, but originially there were, " + this.getOriginalObjectsSize() + ".");
        }
    }
}

