/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.java;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import org.eclipse.persistence.Version;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetClassLoaderForClass;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedGetContextClassLoader;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredField;
import org.eclipse.persistence.internal.security.PrivilegedGetFields;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;
import org.eclipse.persistence.internal.security.PrivilegedGetMethodParameterTypes;
import org.eclipse.persistence.internal.security.PrivilegedGetMethodReturnType;
import org.eclipse.persistence.internal.security.PrivilegedGetValueFromField;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.security.PrivilegedSetValueInField;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestProblemException;

public class DoPrivilegedTest
extends PerformanceComparisonTestCase {
    public DoPrivilegedTest() {
        this.setName("Direct calls vs. doPrivileged vs. Bypassing doPrivileged PerformanceComparisonTest");
        this.setDescription("This test compares the performance for doPrivileged.");
        String usePrivileged = System.getProperty("eclipselink.security.usedoprivileged");
        if (System.getSecurityManager() == null || usePrivileged == null || usePrivileged.equalsIgnoreCase("false")) {
            this.addBypassDoPrivilegedTest();
        } else {
            this.addDoPrivilegedTest();
        }
    }

    public void test() throws Exception {
        String className = "org.eclipse.persistence.Version";
        String fieldName = "buildNumber";
        String fieldValue = "TopLink Blah";
        String methodName = "setProduct";
        Class<?> clazz = null;
        Version version = null;
        Method method = null;
        try {
            clazz = Class.forName(className);
            Class[] methodParameterTypes = new Class[]{Class.forName("java.lang.String")};
            ClassLoader clazzloader = clazz.getClassLoader();
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            Class.forName(className, true, clazzloader);
            version = (Version)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            Field[] fields = clazz.getFields();
            Field field = this.getDeclaredField(clazz, fieldName, true);
            try {
                int n = field.getInt(version);
            }
            catch (Exception exception) {
                // empty catch block
            }
            field.get(version);
            try {
                field.set(version, fieldValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String lineSeparator = System.getProperty("file.separator");
            method = this.getDeclaredMethod(clazz, methodName, methodParameterTypes, true);
            method.getParameterTypes();
            method.getReturnType();
            Object[] parameters = new Object[]{"TopLink Blah."};
            method.invoke((Object)version, parameters);
            Constructor<?> constructor = clazz.getConstructor(null);
            constructor.setAccessible(true);
            Constructor<?> declaredConstructor = clazz.getDeclaredConstructor(null);
            declaredConstructor.setAccessible(true);
            constructor.newInstance(null);
        }
        catch (Exception e) {
            throw new TestProblemException("An exception has been caught.");
        }
    }

    public void addDoPrivilegedTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                DoPrivilegedTest.this.testDoPrivileged();
            }
        };
        test.setName("DoPrivilegedTest");
        test.setAllowableDecrease(-35.0);
        this.addTest((TestCase)test);
    }

    public void addBypassDoPrivilegedTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                DoPrivilegedTest.this.testDoPrivileged();
            }
        };
        test.setName("BypassDoPrivilegedTest");
        test.setAllowableDecrease(-10.0);
        this.addTest((TestCase)test);
    }

    public void testDoPrivileged() {
        String className = "org.eclipse.persistence.Version";
        String fieldName = "product";
        String fieldValue = "TopLink Blah";
        String methodName = "setProduct";
        Class clazz = null;
        Version version = null;
        Method method = null;
        try {
            clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(className));
            Class[] methodParameterTypes = new Class[]{(Class)AccessController.doPrivileged(new PrivilegedClassForName("java.lang.String"))};
            ClassLoader clazzloader = (ClassLoader)AccessController.doPrivileged(new PrivilegedGetClassLoaderForClass(clazz));
            ClassLoader classloader = (ClassLoader)AccessController.doPrivileged(new PrivilegedGetContextClassLoader(Thread.currentThread()));
            AccessController.doPrivileged(new PrivilegedClassForName(className, true, clazzloader));
            version = (Version)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz));
            Field[] fields = (Field[])AccessController.doPrivileged(new PrivilegedGetFields(clazz));
            Field field = (Field)AccessController.doPrivileged(new PrivilegedGetDeclaredField(clazz, fieldName, true));
            try {
                int n = (Integer)AccessController.doPrivileged(new PrivilegedGetValueFromField(field, (Object)version));
            }
            catch (Exception exception) {
                // empty catch block
            }
            AccessController.doPrivileged(new PrivilegedGetValueFromField(field, (Object)version));
            try {
                AccessController.doPrivileged(new PrivilegedSetValueInField(field, (Object)version, (Object)fieldValue));
            }
            catch (Exception exception) {
                // empty catch block
            }
            String lineSeparator = PrivilegedAccessHelper.getLineSeparator();
            method = (Method)AccessController.doPrivileged(new PrivilegedGetMethod(clazz, methodName, methodParameterTypes, true));
            AccessController.doPrivileged(new PrivilegedGetMethodParameterTypes(method));
            AccessController.doPrivileged(new PrivilegedGetMethodReturnType(method));
            Object[] parameters = new Object[]{"TopLink Blah."};
            AccessController.doPrivileged(new PrivilegedMethodInvoker(method, (Object)version, parameters));
            Constructor constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(clazz, null, true));
            Constructor declaredConstructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetDeclaredConstructorFor(clazz, null, true));
            AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, null));
        }
        catch (Exception e) {
            throw new TestProblemException("An exception has been caught.");
        }
    }

    public Field getDeclaredField(Class javaClass, String fieldName, boolean shouldSetAccessible) throws NoSuchFieldException {
        Field field = this.findDeclaredField(javaClass, fieldName);
        if (shouldSetAccessible) {
            field.setAccessible(true);
        }
        return field;
    }

    public Method getDeclaredMethod(Class javaClass, String methodName, Class[] methodParameterTypes, boolean shouldSetAccessible) throws NoSuchMethodException {
        Method method = this.findDeclaredMethod(javaClass, methodName, methodParameterTypes);
        if (shouldSetAccessible) {
            method.setAccessible(true);
        }
        return method;
    }

    private Field findDeclaredField(Class javaClass, String fieldName) throws NoSuchFieldException {
        try {
            return javaClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException ex) {
            Class superclass = javaClass.getSuperclass();
            if (superclass == null) {
                throw ex;
            }
            return this.findDeclaredField(superclass, fieldName);
        }
    }

    private Method findDeclaredMethod(Class javaClass, String methodName, Class[] methodParameterTypes) throws NoSuchMethodException {
        try {
            return javaClass.getDeclaredMethod(methodName, methodParameterTypes);
        }
        catch (NoSuchMethodException ex) {
            Class superclass = javaClass.getSuperclass();
            if (superclass == null) {
                throw ex;
            }
            return this.findDeclaredMethod(superclass, methodName, methodParameterTypes);
        }
    }
}

