/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance;

import java.io.IOException;
import java.io.Writer;
import java.sql.Date;
import junit.framework.Test;
import org.eclipse.persistence.Version;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.bigbad.BigBadSystem;
import org.eclipse.persistence.testing.models.interfaces.InterfaceHashtableProject;
import org.eclipse.persistence.testing.models.performance.Address;
import org.eclipse.persistence.testing.models.performance.EmploymentPeriod;
import org.eclipse.persistence.testing.models.performance.toplink.Employee;
import org.eclipse.persistence.testing.models.performance.toplink.EmployeeSystem;
import org.eclipse.persistence.testing.models.performance.toplink.PhoneNumber;
import org.eclipse.persistence.testing.tests.performance.PerformanceTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadAllAddressTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadAllBigBadObjectTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadAllCompletelyBatchedEmployeeTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadAllCompletelyEmployeeTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadAllCompletelyJoinedEmployeeTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadAllComplexExpressionEmployeeTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadAllComplexExpressionUnitOfWorkConformEmployeeTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadAllEmployeeTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadAllExpressionInheritanceProjectTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadAllHugeCacheAddressTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadAllInMemoryComplexExpressionEmployeeTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadAllInMemoryEmployeeTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadAllUnitOfWorkConformingEmployeeTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadAllUnitOfWorkEmployeeTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadObjectByPrimaryKeyAddressTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadObjectByPrimaryKeyBigBadObjectTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadObjectByPrimaryKeyEmployeeTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadObjectCompletelyEmployeeTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadObjectComplexExpressionEmployeeTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadObjectInMemoryComplexExpressionEmployeeTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadObjectInMemoryEmployeeTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadObjectNamedQueryEmployeeTest;
import org.eclipse.persistence.testing.tests.performance.writing.ComplexUpdateEmployeeUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.performance.writing.InsertAddressUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.performance.writing.InsertBigBadObjectUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.performance.writing.InsertDeleteAddressUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.performance.writing.InsertEmployeeUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.performance.writing.UnitOfWorkNoChangesClientSessionEmployeeTest;
import org.eclipse.persistence.testing.tests.performance.writing.UpdateAddressUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.performance.writing.UpdateBigBadObjectUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.performance.writing.UpdateEmployeeUnitOfWorkTest;

public class PerformanceTestModel
extends TestModel {
    protected Session oldSession;

    public PerformanceTestModel() {
        this.setDescription("This tests the performance of various toplink operations/ fine grained use cases.");
    }

    public void addRequiredSystems() {
        this.addRequiredSystem(new EmployeeSystem());
        this.addRequiredSystem(new BigBadSystem());
    }

    public void addTests() {
        this.addTest((Test)this.getReadingTestSuite());
        this.addTest((Test)this.getWritingTestSuite());
    }

    public TestSuite getReadingTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("ReadingTestSuite");
        suite.setDescription("This suite tests reading performance.");
        suite.addTest((Test)new ReadObjectByPrimaryKeyEmployeeTest());
        PerformanceTest test = new ReadObjectByPrimaryKeyEmployeeTest();
        test.setShouldCache(true);
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new ReadObjectByPrimaryKeyEmployeeTest();
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new ReadObjectByPrimaryKeyEmployeeTest();
        test.setShouldUseEmulatedDB(true);
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new ReadObjectByPrimaryKeyAddressTest();
        test.setShouldCache(true);
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new ReadObjectByPrimaryKeyAddressTest();
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new ReadObjectByPrimaryKeyBigBadObjectTest();
        test.setShouldCache(true);
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new ReadObjectByPrimaryKeyBigBadObjectTest();
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new ReadObjectCompletelyEmployeeTest();
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new ReadObjectComplexExpressionEmployeeTest();
        test.setShouldCache(true);
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        suite.addTest((Test)new ReadObjectInMemoryEmployeeTest());
        suite.addTest((Test)new ReadObjectInMemoryComplexExpressionEmployeeTest());
        test = new ReadObjectNamedQueryEmployeeTest();
        test.setShouldCache(true);
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new ReadObjectNamedQueryEmployeeTest();
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        suite.addTest((Test)new ReadAllEmployeeTest());
        test = new ReadAllEmployeeTest();
        test.setShouldCache(true);
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new ReadAllEmployeeTest();
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new ReadAllEmployeeTest();
        test.setShouldUseEmulatedDB(true);
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new ReadAllUnitOfWorkEmployeeTest();
        test.setShouldCache(true);
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new ReadAllUnitOfWorkEmployeeTest();
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new ReadAllComplexExpressionUnitOfWorkConformEmployeeTest();
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new ReadAllUnitOfWorkConformingEmployeeTest();
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new ReadAllComplexExpressionEmployeeTest();
        test.setShouldCache(true);
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new ReadAllComplexExpressionEmployeeTest();
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        suite.addTest((Test)new ReadAllInMemoryEmployeeTest());
        suite.addTest((Test)new ReadAllInMemoryComplexExpressionEmployeeTest());
        test = new ReadAllCompletelyEmployeeTest();
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new ReadAllCompletelyJoinedEmployeeTest();
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new ReadAllCompletelyBatchedEmployeeTest();
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new ReadAllAddressTest();
        test.setShouldCache(true);
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new ReadAllAddressTest();
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new ReadAllBigBadObjectTest();
        test.setShouldCache(true);
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new ReadAllBigBadObjectTest();
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        suite.addTest((Test)new ReadAllExpressionInheritanceProjectTest());
        test = new ReadAllExpressionInheritanceProjectTest();
        test.setShouldCache(true);
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new ReadAllExpressionInheritanceProjectTest();
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new ReadAllHugeCacheAddressTest();
        test.setShouldCache(true);
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new ReadAllHugeCacheAddressTest();
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        return suite;
    }

    public TestSuite getWritingTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("WritingTestSuite");
        suite.setDescription("This suite tests unit of work and writing performance.");
        PerformanceTest test = new UpdateEmployeeUnitOfWorkTest();
        test.setShouldCache(true);
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new UpdateEmployeeUnitOfWorkTest();
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new UpdateEmployeeUnitOfWorkTest();
        test.setShouldUseEmulatedDB(true);
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new ComplexUpdateEmployeeUnitOfWorkTest();
        test.setShouldCache(true);
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new ComplexUpdateEmployeeUnitOfWorkTest();
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new UpdateAddressUnitOfWorkTest();
        test.setShouldCache(true);
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new UpdateAddressUnitOfWorkTest();
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new UpdateBigBadObjectUnitOfWorkTest();
        test.setShouldCache(true);
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        suite.addTest((Test)new UnitOfWorkNoChangesClientSessionEmployeeTest());
        test = new InsertAddressUnitOfWorkTest();
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        suite.addTest((Test)new InsertEmployeeUnitOfWorkTest());
        test = new InsertEmployeeUnitOfWorkTest();
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new InsertEmployeeUnitOfWorkTest();
        test.setShouldUseEmulatedDB(true);
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new InsertBigBadObjectUnitOfWorkTest();
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        test = new InsertDeleteAddressUnitOfWorkTest();
        test.setShouldUseParameterizedSQL(true);
        suite.addTest((Test)test);
        return suite;
    }

    public void setup() {
        for (int j = 0; j < 100; ++j) {
            Employee empInsert = new Employee();
            empInsert.setFirstName("Brendan");
            empInsert.setMale();
            empInsert.setLastName("" + j + "");
            empInsert.setSalary(100000);
            EmploymentPeriod employmentPeriod = new EmploymentPeriod();
            Date startDate = Helper.dateFromString((String)"1901-12-31");
            Date endDate = Helper.dateFromString((String)"1895-01-01");
            employmentPeriod.setEndDate(endDate);
            employmentPeriod.setStartDate(startDate);
            empInsert.setPeriod(employmentPeriod);
            empInsert.setAddress(new Address());
            empInsert.getAddress().setCity("Nepean");
            empInsert.getAddress().setPostalCode("N5J2N5");
            empInsert.getAddress().setProvince("ON");
            empInsert.getAddress().setStreet("1111 Mountain Blvd. Floor 13, suite " + j);
            empInsert.getAddress().setCountry("Canada");
            empInsert.addPhoneNumber(new PhoneNumber("Work Fax", "613", "2255943"));
            empInsert.addPhoneNumber(new PhoneNumber("Home", "613", "2224599"));
            this.getDatabaseSession().insertObject((Object)empInsert);
        }
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.oldSession = this.getSession();
        Server session = this.getSession().getProject().createServerSession();
        if (Version.getVersion().indexOf("10.1.3") != -1) {
            session.getLogin().setShouldBindAllParameters(true);
        }
        session.addDescriptors((Project)new InterfaceHashtableProject());
        session.setSessionLog(this.getSession().getSessionLog());
        session.login();
        this.getExecutor().setSession((Session)session);
    }

    public void reset() {
        if (this.oldSession != null) {
            this.getDatabaseSession().logout();
            this.getExecutor().setSession(this.oldSession);
        }
    }

    protected void logHeadNote(Writer log) {
        super.logHeadNote(log);
        try {
            if (!System.getProperties().containsKey("toplink.loadbuild.baseline-version")) {
                log.write(this.getIndentationString() + "BASELINE VERSION: NONE SET" + Helper.cr());
            } else {
                String baselineVersion = System.getProperties().getProperty("toplink.loadbuild.baseline-version");
                log.write(this.getIndentationString() + "BASELINE VERSION: " + baselineVersion + Helper.cr());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

