/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.junit.failover;

import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.ArrayRecord;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.DefaultSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.tests.junit.failover.Address;
import org.eclipse.persistence.testing.tests.junit.failover.emulateddriver.EmulatedConnection;
import org.eclipse.persistence.testing.tests.junit.failover.emulateddriver.EmulatedDriver;
import org.junit.After;
import org.junit.Before;

public abstract class FailoverBase<T extends DatabaseSession> {
    private T session;

    @Before
    public void prepare() {
        DatabaseLogin login = new DatabaseLogin();
        login.useDirectDriverConnect();
        login.setDriverClass(EmulatedDriver.class);
        login.setConnectionString("jdbc:emulateddriver");
        login.getPlatform().setPingSQL("SELECT 1");
        Project p = new Project(login);
        ClassDescriptor cd = Address.descriptor();
        p.addDescriptor(cd);
        this.session = this.createSession(p);
        DefaultSessionLog log = new DefaultSessionLog((Writer)new OutputStreamWriter(System.out));
        int logLevel = AbstractSessionLog.translateStringToLoggingLevel((String)System.getProperty("eclipselink.logging.level", "INFO"));
        this.session.setSessionLog((SessionLog)log);
        this.session.setLogLevel(logLevel);
        this.session.login();
        EmulatedConnection con = (EmulatedConnection)((DatabaseSessionImpl)this.session).getAccessor().getConnection();
        final Vector<DatabaseField> pingFields = new Vector<DatabaseField>(){
            {
                this.add(new DatabaseField("1"));
            }
        };
        con.putRows("SELECT 1", new Vector(){
            {
                this.add(new ArrayRecord(pingFields, pingFields.toArray(new DatabaseField[0]), new Object[]{"1"}));
            }
        });
        con.putRows(Address.getSQL(), Address.getData(cd));
    }

    protected abstract T createSession(Project var1);

    protected T getEmulatedSession() {
        return this.session;
    }

    @After
    public void reset() {
        if (this.session != null && this.session.isConnected()) {
            try {
                this.session.logout();
            }
            finally {
                this.session = null;
            }
        }
    }
}

