/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.isolatedsession;

import org.eclipse.persistence.internal.sessions.IsolatedClientSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.isolatedsession.ClientServerTest;
import org.eclipse.persistence.testing.tests.isolatedsession.IsolatedEmployee;

public class VerifyIsolationTest
extends ClientServerTest {
    public IsolatedEmployee readEmployee;

    public VerifyIsolationTest(boolean isExclusive) {
        super(isExclusive);
        this.setDescription("This test verifies that certain data is only available to the client with exclusiveConnectionMode");
    }

    public VerifyIsolationTest(String exclusiveConnectionMode) {
        super(exclusiveConnectionMode, true);
        this.setDescription("This test verifies that certain data is only available to the client with exclusiveConnectionMode " + this.exclusiveConnectionMode);
        this.setName(this.getName() + " " + this.exclusiveConnectionMode);
    }

    @Override
    public void test() {
        Session session = (Session)this.clients.get(0);
        if (!(session instanceof IsolatedClientSession)) {
            throw new TestErrorException("The session created was not an Isolated Session");
        }
        this.readEmployee = (IsolatedEmployee)session.readObject(IsolatedEmployee.class);
        this.readEmployee.getPhoneNumbers();
        this.readEmployee.getAddress();
    }

    @Override
    public void verify() {
        if (this.server.getIdentityMapAccessor().getFromIdentityMap((Object)this.readEmployee) != null) {
            throw new TestErrorException("The Employee class was not Isolated");
        }
        if (this.readEmployee.getPhoneNumbers().isEmpty() || this.server.getIdentityMapAccessor().getFromIdentityMap(this.readEmployee.getPhoneNumbers().get(0)) != null) {
            throw new TestErrorException("The related class Phonenumber class was not Isolated");
        }
        if (this.server.getIdentityMapAccessor().getFromIdentityMap((Object)this.readEmployee.getAddress()) == null) {
            throw new TestErrorException("The related class address was isolated ");
        }
    }
}

