/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps;

import java.math.BigDecimal;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.identitymaps.RegisterInIdentityMapTest;

public class SetWriteLockInIdentityMapTest
extends RegisterInIdentityMapTest {
    protected Object originalWriteLockValue = new BigDecimal("9999999999999999999999999");
    protected Object retrievedWriteLockValue;

    public SetWriteLockInIdentityMapTest(Class mapClass) {
        super(mapClass);
    }

    private Object getWriteLockValue(Object domainObject) {
        return this.getAbstractSession().getIdentityMapAccessorInstance().getWriteLockValue(this.getSession().getId(domainObject), domainObject.getClass());
    }

    private void setWriteLockValue(Object domainObject, Object writeLockValue) {
        this.getAbstractSession().getIdentityMapAccessorInstance().getIdentityMapManager().setWriteLockValue(this.getSession().getId(domainObject), domainObject.getClass(), writeLockValue);
    }

    @Override
    public void test() {
        super.test();
        this.setWriteLockValue(this.employees.lastElement(), this.originalWriteLockValue);
        this.retrievedWriteLockValue = this.getWriteLockValue(this.employees.lastElement());
    }

    @Override
    public void verify() {
        if (!this.originalWriteLockValue.equals(this.retrievedWriteLockValue) && !this.isNoIdentityMap()) {
            throw new TestErrorException("Write lock original: " + this.originalWriteLockValue + " did not match cached: " + this.retrievedWriteLockValue);
        }
    }
}

