/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps;

import java.math.BigDecimal;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class InitializeIdentityMapByDescriptorJavaClassTest
extends TestCase {
    protected boolean wrongMap = false;

    public InitializeIdentityMapByDescriptorJavaClassTest() {
        this.setDescription("Ensure that descriptors are accessed by their java class rather than the class they are indexed by in the project in initializeIdentityMap.");
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.getSession().readObject(Employee.class);
        this.wrongMap = false;
        ClassDescriptor descriptor = this.getSession().getClassDescriptor(Employee.class);
        this.getSession().getDescriptors().put(BigDecimal.class, descriptor);
    }

    public void test() {
        this.getAbstractSession().getIdentityMapAccessorInstance().initializeIdentityMap(BigDecimal.class);
        IdentityMap employeeIdentityMap = this.getAbstractSession().getIdentityMapAccessorInstance().getIdentityMap(Employee.class);
        if (employeeIdentityMap.getSize() > 0) {
            this.wrongMap = true;
        }
    }

    public void verify() {
        if (this.wrongMap) {
            throw new TestErrorException("InitializeIdentityMap does not access identity maps by it's descriptor's java class.");
        }
    }

    public void reset() {
        this.getSession().getDescriptors().remove(BigDecimal.class);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }
}

