/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import java.io.IOException;
import junit.framework.Test;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeSystem;
import org.eclipse.persistence.testing.tests.employee.EmployeeBasicTestModel;
import org.eclipse.persistence.testing.tests.feature.BatchWritingTest;
import org.eclipse.persistence.testing.tests.feature.QueryTimeoutBatchDynamicDataModifyDatabaseQueryParentRefExceptionTest;
import org.eclipse.persistence.testing.tests.feature.QueryTimeoutBatchDynamicDatabaseQueryTest;
import org.eclipse.persistence.testing.tests.feature.QueryTimeoutBatchDynamicDescriptorQueryManagerTest;
import org.eclipse.persistence.testing.tests.feature.QueryTimeoutBatchParameterizedDatabaseQueryTest;
import org.eclipse.persistence.testing.tests.feature.QueryTimeoutBatchParameterizedDescriptorQueryManagerTest;

public class TopLinkBatchUpdatesTestModel
extends TestModel {
    Boolean wasBatchWriting;
    Boolean wasJDBCBatchWriting;
    Boolean wasParameterBinding;

    public void addForcedRequiredSystems() {
        DatabasePlatform platform = this.getSession().getPlatform();
        this.wasBatchWriting = platform.usesBatchWriting();
        this.wasJDBCBatchWriting = platform.usesJDBCBatchWriting();
        this.wasParameterBinding = this.getSession().getLogin().shouldBindAllParameters();
        try {
            this.getSession().getLog().write("WARNING, some JDBC drivers may fail BatchUpdates.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!(platform.isSybase() || platform.isSQLAnywhere() || platform.isOracle() || platform.isSQLServer() || platform.isAttunity())) {
            throw new TestWarningException("TopLink batch writing is not supported on this database.");
        }
        platform.setUsesBatchWriting(true);
        platform.setUsesJDBCBatchWriting(false);
        platform.setMaxBatchWritingSize(3200);
        this.getSession().getLogin().dontBindAllParameters();
        this.getExecutor().removeConfigureSystem((TestSystem)new EmployeeSystem());
        this.addForcedRequiredSystem(new EmployeeSystem());
    }

    public void addTests() {
        TestSuite suite = new TestSuite();
        suite.setName("BatchWriteTests");
        suite.addTest((Test)new BatchWritingTest());
        suite.addTest((Test)new QueryTimeoutBatchParameterizedDescriptorQueryManagerTest());
        suite.addTest((Test)new QueryTimeoutBatchDynamicDescriptorQueryManagerTest());
        suite.addTest((Test)new QueryTimeoutBatchParameterizedDatabaseQueryTest());
        suite.addTest((Test)new QueryTimeoutBatchDynamicDatabaseQueryTest());
        suite.addTest((Test)new QueryTimeoutBatchDynamicDataModifyDatabaseQueryParentRefExceptionTest());
        this.addTest((Test)EmployeeBasicTestModel.getReadObjectTestSuite());
        this.addTest((Test)EmployeeBasicTestModel.getReadAllTestSuite());
        this.addTest((Test)EmployeeBasicTestModel.getUpdateObjectTestSuite());
        this.addTest((Test)EmployeeBasicTestModel.getInsertObjectTestSuite());
        this.addTest((Test)EmployeeBasicTestModel.getDeleteObjectTestSuite());
        this.addTest((Test)suite);
    }

    public void reset() {
        DatabasePlatform platform = this.getSession().getPlatform();
        if (this.wasBatchWriting != null) {
            platform.setUsesBatchWriting(this.wasBatchWriting.booleanValue());
        }
        if (this.wasJDBCBatchWriting != null) {
            platform.setUsesJDBCBatchWriting(this.wasJDBCBatchWriting.booleanValue());
        }
        if (this.wasParameterBinding != null) {
            platform.setShouldBindAllParameters(this.wasParameterBinding.booleanValue());
        }
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }
}

