/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.dynamic.entitytype;

import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.dynamic.DynamicTypeBuilder;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.tests.dynamic.DynamicTestingHelper;
import org.eclipse.persistence.testing.tests.dynamic.entitytype.MyEntity;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class EntityTypeFromScratch {
    static final String TABLE_NAME = "MY_ENTITY";

    @AfterClass
    public static void tearDown() {
        DatabaseSession ds = DynamicTestingHelper.createSession();
        ds.login();
        ds.executeNonSelectingSQL("DROP TABLE MY_ENTITY");
        ds.logout();
    }

    @Test
    public void entityTypeFromDescriptor() throws Exception {
        DynamicType entityType = this.buildMyEntityType();
        Assert.assertEquals(MyEntity.class, (Object)entityType.getJavaClass());
        DatabaseSession session = DynamicTestingHelper.createSession();
        session.login();
        session.addDescriptor(entityType.getDescriptor());
        new SchemaManager(session).replaceDefaultTables();
        DynamicEntity entity = entityType.newDynamicEntity();
        entity.set("id", (Object)1);
        entity.set("name", (Object)"Name");
        session.insertObject((Object)entity);
        session.logout();
    }

    private DynamicType buildMyEntityType() {
        DynamicTypeBuilder factory = new DynamicTypeBuilder(MyEntity.class, null, new String[]{TABLE_NAME});
        factory.setPrimaryKeyFields(new String[]{"ID"});
        factory.addDirectMapping("id", Integer.TYPE, "ID");
        factory.addDirectMapping("name", String.class, "NAME");
        return factory.getType();
    }
}

