/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.collections;

import junit.framework.Test;
import org.eclipse.persistence.testing.framework.DeleteObjectTest;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.UnitOfWorkBasicUpdateObjectTest;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.collections.CollectionsSystem;
import org.eclipse.persistence.testing.models.collections.Restaurant;
import org.eclipse.persistence.testing.tests.collections.CollectionInsertDetectionTest;
import org.eclipse.persistence.testing.tests.collections.CollectionInsertObjectTest;
import org.eclipse.persistence.testing.tests.collections.CollectionReadObjectTest;
import org.eclipse.persistence.testing.tests.collections.CompareKeyWithBackupTest;
import org.eclipse.persistence.testing.tests.collections.OTMHashtableObjectUpdateTest;
import org.eclipse.persistence.testing.tests.collections.OTMPrivateOwnedDeleteObjectTest;
import org.eclipse.persistence.testing.tests.collections.PerformDeletesFirstCollectionObjectRemovalTest;
import org.eclipse.persistence.testing.tests.collections.TreeSetComparatorTest;
import org.eclipse.persistence.testing.tests.collections.UnitOfWorkTest;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class CollectionsTestModel
extends TestModel {
    public CollectionsTestModel() {
        this.setDescription("This model tests reading/writing/deleting of the complex mapping model.");
    }

    public void addRequiredSystems() {
        this.addRequiredSystem(new CollectionsSystem());
    }

    public void addTests() {
        this.addTest((Test)CollectionsTestModel.getReadObjectTestSuite());
        this.addTest((Test)CollectionsTestModel.getWriteObjectTestSuite());
        this.addTest((Test)CollectionsTestModel.getDeleteObjectTestSuite());
        this.addTest((Test)CollectionsTestModel.getInsertObjectTestSuite());
        this.addTest((Test)CollectionsTestModel.getUnitOfWorkTestSuite());
        this.addTest((Test)new CompareKeyWithBackupTest());
        this.addTest((Test)new TreeSetComparatorTest());
    }

    public static TestSuite getDeleteObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("CollectionsDeleteObjectTestSuite");
        suite.setDescription("This suite tests the deletion of each object in the collections model.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Restaurant.class, "example1")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Restaurant.class, "example2")));
        suite.addTest((Test)new OTMPrivateOwnedDeleteObjectTest());
        return suite;
    }

    public static TestSuite getInsertObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("CollectionsInsertObjectTestSuite");
        suite.setDescription("This suite tests the insertion of each object in the collections model.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new CollectionInsertObjectTest(CollectionInsertObjectTest.buildInstanceToInsert()));
        suite.addTest((Test)new CollectionInsertDetectionTest());
        return suite;
    }

    public static TestSuite getReadObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("CollectionsReadObjectTestSuite");
        suite.setDescription("This suite test the reading of each object in the Collections model.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new CollectionReadObjectTest(manager.getObject(Restaurant.class, "example1")));
        suite.addTest((Test)new CollectionReadObjectTest(manager.getObject(Restaurant.class, "example2")));
        return suite;
    }

    public static TestSuite getUnitOfWorkTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("CollectionsUnitOfWorkTestSuite");
        suite.setDescription("This suite test the reading of each object in the mapping model.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new UnitOfWorkTest(manager.getObject(Restaurant.class, "example1")));
        suite.addTest((Test)new UnitOfWorkTest(manager.getObject(Restaurant.class, "example2")));
        suite.addTest((Test)new OTMHashtableObjectUpdateTest());
        suite.addTest((Test)new PerformDeletesFirstCollectionObjectRemovalTest(false));
        suite.addTest((Test)new PerformDeletesFirstCollectionObjectRemovalTest(true));
        return suite;
    }

    public static TestSuite getWriteObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("CollectionsWriteObjectTestSuite");
        suite.setDescription("This suite test the writing of each object in the mapping model.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new WriteObjectTest(manager.getObject(Restaurant.class, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(Restaurant.class, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(Restaurant.class, "example2")));
        return suite;
    }
}

