/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.aggregate;

import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.aggregate.Cousin;
import org.eclipse.persistence.testing.models.aggregate.Parent;

public class AggregateRelationshipsOneToOneTestCase
extends TestCase {
    protected Parent originalParent;
    protected Parent readParent;

    public AggregateRelationshipsOneToOneTestCase() {
        this.setDescription("AggregateRelationships: test OneToOneMapping");
    }

    public void setup() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.originalParent = new Parent();
        this.originalParent.getAggregate().setCousin(new Cousin());
        uow.registerObject((Object)this.originalParent);
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void test() {
        int id = this.originalParent.getId();
        try {
            this.readParent = (Parent)this.getSession().readObject(Parent.class, new ExpressionBuilder().get("id").equal(id));
        }
        catch (EclipseLinkException exception) {
            this.throwError("An exception occurred whilst reading back a Parent object with id " + id, exception);
        }
    }

    public void verify() {
        AggregateRelationshipsOneToOneTestCase.assertNotNull((String)"Parent read back should not be null", (Object)this.readParent);
        this.compareObjects(this.originalParent, this.readParent);
        this.compareObjects(this.originalParent.getAggregate().getCousin(), this.readParent.getAggregate().getCousin());
    }

    public void reset() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.deleteObject((Object)this.originalParent.getAggregate().getCousin());
        uow.deleteObject((Object)this.originalParent);
        uow.commit();
    }
}

