/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.events;

import java.math.BigDecimal;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.testing.models.events.Customer;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class Order {
    public Number id;
    public String sku;
    public int quantity;
    public Customer customer;

    public static RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Order.class);
        descriptor.setTableName("EVENTORDER");
        descriptor.setPrimaryKeyFieldName("ID");
        descriptor.setSequenceNumberName("SEQ");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.addDirectMapping("id", "ID");
        descriptor.addDirectMapping("sku", "SKU");
        descriptor.addDirectMapping("quantity", "QUANTITY");
        OneToOneMapping customerMapping = new OneToOneMapping();
        customerMapping.setAttributeName("customer");
        customerMapping.setReferenceClass(Customer.class);
        customerMapping.dontUseIndirection();
        customerMapping.addForeignKeyFieldName("EVENTORDER.CUSTOMER_ID", "EVENTCUSTOMER.ID");
        descriptor.addMapping((DatabaseMapping)customerMapping);
        return descriptor;
    }

    public static Order example1() {
        Order order = new Order();
        order.sku = "556995655856";
        order.quantity = 5;
        return order;
    }

    public static Order example2() {
        Order order = new Order();
        order.sku = "986899568556";
        order.quantity = 1;
        return order;
    }

    public static Order example3() {
        Order order = new Order();
        order.sku = "887521132264";
        order.quantity = 5000;
        return order;
    }

    public static Order example4() {
        Order order = new Order();
        order.sku = "8858787875854";
        order.quantity = 2;
        return order;
    }

    public static TableDefinition tableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName("EVENTORDER");
        definition.addIdentityField("ID", BigDecimal.class, 15);
        definition.addField("QUANTITY", Integer.class, 15);
        definition.addField("SKU", String.class, 40);
        definition.addField("CUSTOMER_ID", BigDecimal.class, 15);
        return definition;
    }
}

