/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.aggregate;

import java.math.BigDecimal;
import java.util.Vector;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.testing.models.aggregate.Company;
import org.eclipse.persistence.testing.models.aggregate.Dependant;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class Customer {
    private String name;
    private BigDecimal id;
    private int income;
    private ValueHolderInterface<Vector<Dependant>> dependants = new ValueHolder(new Vector());
    private ValueHolderInterface<Company> company = new ValueHolder();

    public void addDependant(Dependant dependant) {
        this.getDependants().addElement(dependant);
    }

    public static Customer example1() {
        Customer example1 = new Customer();
        example1.setName("Bob Smith");
        example1.setIncome(94320);
        example1.setCompany(Company.example1());
        Vector<Dependant> dependants = new Vector<Dependant>(2);
        dependants.addElement(Dependant.example1());
        dependants.addElement(Dependant.example2());
        example1.setDependants(dependants);
        return example1;
    }

    public static Customer example2() {
        Customer example2 = new Customer();
        example2.setName("Jack Johnson");
        example2.setIncome(773388);
        example2.setCompany(Company.example2());
        Vector<Dependant> dependants = new Vector<Dependant>(1);
        dependants.addElement(Dependant.example3());
        example2.setDependants(dependants);
        return example2;
    }

    public static Customer example3() {
        Customer example3 = new Customer();
        example3.setName("Linda Lindros");
        example3.setIncome(38338);
        example3.setCompany(Company.example3());
        Vector<Dependant> dependants = new Vector<Dependant>(2);
        dependants.addElement(Dependant.example4());
        dependants.addElement(Dependant.example5());
        example3.setDependants(dependants);
        return example3;
    }

    public Company getCompany() {
        return (Company)this.company.getValue();
    }

    public ValueHolderInterface<Company> getCompanyValueHolder() {
        return this.company;
    }

    public Vector<Dependant> getDependants() {
        return (Vector)this.dependants.getValue();
    }

    public ValueHolderInterface getDependantValueHolder() {
        return this.dependants;
    }

    public BigDecimal getId() {
        return this.id;
    }

    public int getIncome() {
        return this.income;
    }

    public String getName() {
        return this.name;
    }

    public void removeDependant(Dependant dependant) {
        this.getDependants().removeElement(dependant);
    }

    public void setCompany(Company newCompany) {
        this.company.setValue((Object)newCompany);
    }

    public void setCompanyValueHolder(ValueHolderInterface<Company> newCompany) {
        this.company = newCompany;
    }

    public void setDependants(Vector dependants) {
        this.getDependantValueHolder().setValue((Object)dependants);
    }

    public void setDependantValueHolder(ValueHolderInterface<Vector<Dependant>> dependants) {
        this.dependants = dependants;
    }

    public void setId(BigDecimal newId) {
        this.id = newId;
    }

    public void setIncome(int newIncome) {
        this.income = newIncome;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public static TableDefinition tableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName("CUSTOMER");
        definition.addIdentityField("CUSTOMER_ID", BigDecimal.class, 15);
        definition.addField("AGENT_ID", BigDecimal.class, 15);
        definition.addField("COMPANY_ID", BigDecimal.class, 15);
        definition.addField("NAME", String.class, 30);
        definition.addField("INCOME", Integer.class, 20);
        return definition;
    }
}

