/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.jpa.xml.merge.incompletemappings.owning;

import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Version;
import org.eclipse.persistence.testing.models.jpa.xml.merge.incompletemappings.owning.Address;
import org.eclipse.persistence.testing.models.jpa.xml.merge.incompletemappings.owning.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.xml.merge.incompletemappings.owning.Project;
import org.eclipse.persistence.testing.models.jpa.xml.merge.incompletemappings.owning.SecurityBadge;

@Entity(name="XMLIncompleteMergeEmplyee")
@Table(name="CMP3_XML_MERGE_EMPLOYEE")
@PrimaryKeyJoinColumn(name="EMP_ID", referencedColumnName="EMP_ID")
public class Employee
implements Serializable {
    private Integer id;
    private int version;
    private String firstName;
    private String lastName;
    private Address address;
    private Collection<PhoneNumber> phoneNumbers = new Vector<PhoneNumber>();
    private Collection<Project> projects = new Vector<Project>();
    private Collection<Employee> managedEmployees = new Vector<Employee>();
    private Employee manager;
    private SecurityBadge securityBadge;

    public Employee() {
    }

    public Employee(String firstName, String lastName) {
        this();
        this.firstName = firstName;
        this.lastName = lastName;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="XML_MERGE_EMPLOYEE_TABLE_GENERATOR")
    @TableGenerator(name="XML_MERGE_EMPLOYEE_TABLE_GENERATOR", table="CMP3_XML_MERGE_EMPLOYEE_SEQ", pkColumnName="SEQ_NAME", valueColumnName="SEQ_COUNT", pkColumnValue="XML_MERGE_EMPLOYEE_SEQ")
    @Column(name="EMP_ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Version
    @Column(name="VERSION")
    public int getVersion() {
        return this.version;
    }

    protected void setVersion(int version) {
        this.version = version;
    }

    @Column(name="F_NAME")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String name) {
        this.firstName = name;
    }

    @Column(name="L_NAME")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String name) {
        this.lastName = name;
    }

    @ManyToOne(cascade={CascadeType.PERSIST}, fetch=FetchType.LAZY)
    @JoinColumn(name="ADDR_ID")
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="owner")
    public Collection<PhoneNumber> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public void setPhoneNumbers(Collection<PhoneNumber> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    @OneToOne
    @JoinColumn(name="SECURITYBADGE_BADGE_ID", referencedColumnName="BADGE_ID")
    public SecurityBadge getSecurityBadge() {
        return this.securityBadge;
    }

    public void setSecurityBadge(SecurityBadge securityBadge) {
        this.securityBadge = securityBadge;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="manager")
    public Collection<Employee> getManagedEmployees() {
        return this.managedEmployees;
    }

    public void setManagedEmployees(Collection<Employee> managedEmployees) {
        this.managedEmployees = managedEmployees;
    }

    @ManyToOne(cascade={CascadeType.PERSIST}, fetch=FetchType.LAZY)
    public Employee getManager() {
        return this.manager;
    }

    public void setManager(Employee manager) {
        this.manager = manager;
    }

    @ManyToMany(cascade={CascadeType.PERSIST})
    @JoinTable(name="CMP3_XML_MERGE_PROJ_EMP", joinColumns={@JoinColumn(name="EMPLOYEES_EMP_ID", referencedColumnName="EMP_ID")})
    public Collection<Project> getProjects() {
        return this.projects;
    }

    public void setProjects(Collection<Project> projects) {
        this.projects = projects;
    }

    public void addManagedEmployee(Employee emp) {
        this.getManagedEmployees().add(emp);
        emp.setManager(this);
    }

    public void addPhoneNumber(PhoneNumber phone) {
        phone.setOwner(this);
        this.getPhoneNumbers().add(phone);
    }

    public void addProject(Project theProject) {
        this.getProjects().add(theProject);
    }

    public String toString() {
        return "Employee: " + this.getId();
    }
}

