/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.workbenchintegration.QueryOptions;

import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class QueryTimeOutTest
extends AutoVerifyTestCase {
    private boolean limitExceed;

    public QueryTimeOutTest() {
        this.setDescription("Test the query timeout setting");
        this.limitExceed = false;
    }

    public void test() {
        block6: {
            if (this.getSession().getPlatform().isSymfoware()) {
                this.throwWarning("workbenchintegration.QueryOptions' QueryTimeoutTest skipped for this platform, the driver does not support query time-out.");
            }
            if (this.getSession().getPlatform().isMaxDB()) {
                this.throwWarning("workbenchintegration.QueryOptions' QueryTimeoutTest skipped for this platform, the driver does not support query timeout. (bug 326503)");
            }
            try {
                this.getSession().executeQuery("queryTimeOutQuery", Employee.class);
            }
            catch (Exception e) {
                if (!(e instanceof DatabaseException)) break block6;
                this.limitExceed = true;
            }
        }
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException ex) {
            throw new TestProblemException("Test thread was interrupted.  Test failed to run properly");
        }
    }

    public void verify() {
        if (!this.limitExceed) {
            throw new TestWarningException("Query was executed too fast to get timeout");
        }
    }
}

