/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork.writechanges;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class WriteChanges_DeleteAll_TestCase
extends AutoVerifyTestCase {
    protected Exception exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        try {
            Vector employees = uow.readAllObjects(Employee.class);
            uow.writeChanges();
            DeleteAllQuery deleteAllQuery = new DeleteAllQuery();
            deleteAllQuery.setReferenceClass(Employee.class);
            deleteAllQuery.setObjects((List)employees);
            uow.executeQuery((DatabaseQuery)deleteAllQuery);
        }
        catch (Exception e) {
            this.exception = e;
        }
        finally {
            uow.release();
        }
    }

    public void verify() {
        if (this.exception == null) {
            throw new TestErrorException("Exception not thrown when attempting an ObjectLevelDeleteAllQuery after writeChanges().");
        }
        if (!(this.exception instanceof ValidationException)) {
            throw new TestErrorException("Wrong exception thrown.", (Throwable)this.exception);
        }
    }

    public void reset() {
        this.exception = null;
    }
}

