/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmployeePopulator;

public class UnregisterUnitOfWorkTest
extends AutoVerifyTestCase {
    public UnregisterUnitOfWorkTest() {
        this.setDescription("Check the SQL to see that no inserts are issued.");
    }

    protected void test() {
        Employee employee = (Employee)new EmployeePopulator().employeeExample1();
        UnitOfWorkImpl uow = (UnitOfWorkImpl)this.getSession().acquireUnitOfWork();
        Employee workingCopy = (Employee)uow.registerObject((Object)employee);
        workingCopy.setFirstName("firstName");
        uow.deepUnregisterObject((Object)workingCopy);
        if (!uow.getCloneMapping().isEmpty()) {
            throw new TestErrorException("Deep unregister object did not work");
        }
        if (!uow.getNewObjectsOriginalToClone().isEmpty()) {
            throw new TestErrorException("Deep unregister object did not work");
        }
        if (!uow.getNewObjectsCloneToOriginal().isEmpty()) {
            throw new TestErrorException("Deep unregister object did not work");
        }
        uow.commit();
        uow = (UnitOfWorkImpl)this.getSession().acquireUnitOfWork();
        Vector workingCopies = uow.readAllObjects(Employee.class);
        Enumeration enumtr = workingCopies.elements();
        while (enumtr.hasMoreElements()) {
            uow.deepUnregisterObject(enumtr.nextElement());
        }
        if (!uow.getCloneMapping().isEmpty()) {
            throw new TestErrorException("Deep unregister object did not work");
        }
        if (!uow.getNewObjectsOriginalToClone().isEmpty()) {
            throw new TestErrorException("Deep unregister object did not work");
        }
        if (!uow.getNewObjectsCloneToOriginal().isEmpty()) {
            throw new TestErrorException("Deep unregister object did not work");
        }
        uow.commit();
        uow = (UnitOfWorkImpl)this.getSession().acquireUnitOfWork();
        workingCopy = (Employee)uow.registerObject((Object)employee);
        workingCopy.getAddress();
        workingCopy.getProjects();
        workingCopy.setFirstName("firstName");
        uow.unregisterObject((Object)workingCopy);
        Employee newWorkingCopy = (Employee)uow.registerObject((Object)employee);
        if (workingCopy == newWorkingCopy) {
            throw new TestErrorException("Cascade private parts unregister object did not work");
        }
        if (workingCopy.getAddress() == newWorkingCopy.getAddress()) {
            throw new TestErrorException("Cascade private parts unregister object did not work");
        }
        Enumeration enumtr2 = workingCopy.getProjects().elements();
        while (enumtr2.hasMoreElements()) {
            if (newWorkingCopy.getProjects().contains(enumtr2.nextElement())) continue;
            throw new TestErrorException("Cascade private parts unregister object did not work");
        }
        uow.commit();
        uow = (UnitOfWorkImpl)this.getSession().acquireUnitOfWork();
        workingCopy = (Employee)uow.registerObject((Object)employee);
        workingCopy.getAddress();
        workingCopy.setFirstName("firstName");
        uow.shallowUnregisterObject((Object)workingCopy);
        newWorkingCopy = (Employee)uow.registerObject((Object)employee);
        if (workingCopy == newWorkingCopy) {
            throw new TestErrorException("Shallow unregister object did not work");
        }
        if (workingCopy.getAddress() != newWorkingCopy.getAddress()) {
            throw new TestErrorException("Shallow unregister object did not work");
        }
        uow.commit();
    }
}

