/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.unitofwork.Person;

public class UnitOfWorkDeleteNoValidationTest
extends AutoVerifyTestCase {
    public boolean caughtClassCastException = false;

    public UnitOfWorkDeleteNoValidationTest() {
        this.setDescription("This test tests to ensure there is no ClassCastException thrown when an object is deleted in a UnitOfWork with validation turned off.");
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
    }

    public void test() {
        try {
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            Person personClone = (Person)uow.readObject(Person.class);
            uow.dontPerformValidation();
            uow.deleteObject((Object)personClone);
            uow.commit();
        }
        catch (ClassCastException exception) {
            this.caughtClassCastException = true;
        }
    }

    public void verify() {
        if (this.caughtClassCastException) {
            throw new TestErrorException("A ClassCastException was thrown when an object was deleted in a UnitOfWork with validation turned off.");
        }
    }
}

