/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.tests.unitofwork.MailAddress;
import org.eclipse.persistence.testing.tests.unitofwork.Person;

public class RegisterationUnitOfWorkTest
extends WriteObjectTest {
    public Object unitOfWorkWorkingCopy;
    public UnitOfWork unitOfWork;

    public RegisterationUnitOfWorkTest() {
    }

    public RegisterationUnitOfWorkTest(Object originalObject) {
        super(originalObject);
        this.setDescription("The test registers equal and unequal objects to the database and sees if the' registeration works properly by checking if different clones are returned for similar objects");
    }

    public void setup() {
        super.setup();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.unitOfWork = this.getSession().acquireUnitOfWork();
    }

    protected void test() {
        this.testRegisteringEqualObjects();
        this.testRegisteringUnequalObjects();
        this.unitOfWork.commit();
    }

    protected void testRegisteringEqualObjects() {
        MailAddress addressClone2;
        Person personClone2;
        Person person = Person.example1();
        Person personClone1 = (Person)this.unitOfWork.registerObject((Object)person);
        if (personClone1 != (personClone2 = (Person)this.unitOfWork.registerObject((Object)person))) {
            throw new TestErrorException("Registration fault: Clones are different for equal objects");
        }
        MailAddress address = MailAddress.example1();
        MailAddress addressClone1 = (MailAddress)this.unitOfWork.registerObject((Object)address);
        if (addressClone1 != (addressClone2 = (MailAddress)this.unitOfWork.registerObject((Object)address))) {
            throw new TestErrorException("Registration fault: Clones are different for equal objects");
        }
    }

    protected void testRegisteringUnequalObjects() {
        MailAddress addressClone2;
        Person personClone2;
        Person person1 = Person.example1();
        Person person2 = Person.example2();
        Person personClone1 = (Person)this.unitOfWork.registerObject((Object)person1);
        if (personClone1 == (personClone2 = (Person)this.unitOfWork.registerObject((Object)person2))) {
            throw new TestErrorException("Registration fault: Same clone returned for unequal objects");
        }
        MailAddress address1 = MailAddress.example1();
        MailAddress address2 = MailAddress.example2();
        MailAddress addressClone1 = (MailAddress)this.unitOfWork.registerObject((Object)address1);
        if (addressClone1 == (addressClone2 = (MailAddress)this.unitOfWork.registerObject((Object)address2))) {
            throw new TestErrorException("Registration fault: Same clone returned for unequal objects");
        }
    }
}

