/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.tests.unitofwork.Weather;

public class PerformDeletesFirstTest
extends TransactionalTestCase {
    protected Weather weather = null;

    public PerformDeletesFirstTest() {
        this.setDescription("Verifies that TopLink will Delete objects first if so instructed");
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.setShouldPerformDeletesFirst(true);
        this.weather = (Weather)uow.readObject(Weather.class);
        uow.deleteObject((Object)this.weather);
        long id = this.weather.id;
        this.weather = new Weather();
        this.weather.id = id;
        this.weather.setStormPattern("Hurricane");
        uow.registerNewObject((Object)this.weather);
        try {
            uow.commit();
        }
        catch (QueryException exception) {
            throw new TestErrorException("Test case failed to delete objects first");
        }
    }

    public void verify() {
        ReadObjectQuery query = new ReadObjectQuery((Object)this.weather);
        query.dontCheckCache();
        this.weather = (Weather)this.getSession().executeQuery((DatabaseQuery)query);
        if (this.weather == null) {
            throw new TestErrorException("Object was not in the database after performing delete then insert with PerformDeletesFirst.");
        }
    }
}

