/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.math.BigDecimal;
import org.eclipse.persistence.descriptors.DescriptorEventAdapter;
import org.eclipse.persistence.descriptors.DescriptorEventListener;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.Cursor;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.unitofwork.ConcurrentRefreshEventAdapter;

public class ConcurrentRefreshOnUpdateTest
extends AutoVerifyTestCase {
    public static Employee lock;
    public static boolean writerWaiting;
    public static boolean readerWaiting;
    public static int version;
    public DescriptorEventAdapter adaptor;
    public static int depth;
    public boolean writer;
    public Session session;

    public ConcurrentRefreshOnUpdateTest() {
        this.adaptor = new ConcurrentRefreshEventAdapter();
    }

    public ConcurrentRefreshOnUpdateTest(boolean writer, Session session) {
        this.writer = writer;
        this.session = session;
    }

    public void setup() {
        if (this.getSession().isDistributedSession()) {
            throw new TestWarningException("Test unavailable on Remote UnitOfWork because of timing issues");
        }
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.getSession().getDescriptor(Employee.class).getEventManager().addListener((DescriptorEventListener)this.adaptor);
    }

    public void test() {
        lock = (Employee)this.getSession().readObject(Employee.class);
        BigDecimal primaryKey = lock.getId();
        version = ((Number)this.getSession().getDescriptor(Employee.class).getOptimisticLockingPolicy().getWriteLockValue((Object)lock, (Object)primaryKey, (AbstractSession)this.getSession())).intValue();
        String oldName = lock.getFirstName();
        Thread thread1 = null;
        Thread thread2 = null;
        try {
            thread1 = new Thread(new ConcurrentRefreshOnUpdateTest(true, this.getSession()).runnable());
            thread1.start();
            thread2 = new Thread(new ConcurrentRefreshOnUpdateTest(false, this.getSession()).runnable());
            thread2.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            thread1.join();
            thread2.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (version != ((Number)this.getSession().getDescriptor(Employee.class).getOptimisticLockingPolicy().getWriteLockValue((Object)lock, (Object)primaryKey, (AbstractSession)this.getSession())).intValue() && lock.getFirstName().equals(oldName)) {
            throw new TestErrorException("The refresh over wrote new data but left the new version");
        }
    }

    public Runnable runnable() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (ConcurrentRefreshOnUpdateTest.this.writer) {
                    UnitOfWork uow = ConcurrentRefreshOnUpdateTest.this.session.acquireUnitOfWork();
                    Employee empClone = (Employee)uow.registerObject((Object)lock);
                    empClone.setFirstName("The New City Name" + System.currentTimeMillis());
                    Employee employee = lock;
                    synchronized (employee) {
                        if (readerWaiting) {
                            lock.notifyAll();
                        } else {
                            writerWaiting = true;
                            try {
                                lock.wait(30000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            writerWaiting = false;
                        }
                    }
                    uow.commit();
                } else {
                    ReadAllQuery query = new ReadAllQuery(Employee.class);
                    query.setShouldRefreshIdentityMapResult(true);
                    query.useCursoredStream(0, 1);
                    query.setSelectionCriteria(new ExpressionBuilder().get("id").equal((Object)lock.getId()));
                    Cursor cursor = (Cursor)ConcurrentRefreshOnUpdateTest.this.session.executeQuery((DatabaseQuery)query);
                    Employee employee = lock;
                    synchronized (employee) {
                        if (writerWaiting) {
                            lock.notifyAll();
                        } else {
                            readerWaiting = true;
                            try {
                                lock.wait(30000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            readerWaiting = false;
                        }
                    }
                    Thread.yield();
                    employee = lock;
                    synchronized (employee) {
                        if (!writerWaiting) {
                            readerWaiting = true;
                            try {
                                lock.wait(30000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            readerWaiting = false;
                        }
                    }
                    if (cursor.hasMoreElements()) {
                        cursor.nextElement();
                    }
                    cursor.close();
                }
            }
        };
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.getSession().getDescriptor(Employee.class).getEventManager().removeListener((DescriptorEventListener)this.adaptor);
    }

    static {
        writerWaiting = false;
        readerWaiting = false;
    }
}

