/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmploymentPeriod;

public class BuildCloneFromRowOneToOneTest
extends AutoVerifyTestCase {
    public Employee emp;
    public Employee manager;
    public Address address;

    public Address addressExample1() {
        Address address = new Address();
        address.setCity("Toronto");
        address.setPostalCode("L5J2B5");
        address.setProvince("ONT");
        address.setStreet("1450 Acme Cr., suite 4");
        address.setCountry("Canada");
        return address;
    }

    public Employee createNewEmployeeObject() {
        Employee employee = new Employee();
        employee.setFirstName("Judy");
        employee.setLastName("Barney");
        employee.setFemale();
        employee.setSalary(35000);
        employee.setPeriod(this.employmentPeriodExample());
        return employee;
    }

    public Employee createNewManagerObject() {
        Employee employee = new Employee();
        employee.setFirstName("Markus" + System.currentTimeMillis());
        employee.setLastName("Markson");
        employee.setMale();
        employee.setSalary(35000);
        employee.setPeriod(this.employmentPeriodExample());
        return employee;
    }

    public EmploymentPeriod employmentPeriodExample() {
        EmploymentPeriod employmentPeriod = new EmploymentPeriod();
        employmentPeriod.setEndDate(Helper.dateFromYearMonthDate((int)1996, (int)0, (int)1));
        employmentPeriod.setStartDate(Helper.dateFromYearMonthDate((int)1993, (int)0, (int)1));
        return employmentPeriod;
    }

    public void reset() {
        if (this.getAbstractSession().isInTransaction()) {
            this.getAbstractSession().rollbackTransaction();
        }
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
    }

    public void test() throws Exception {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.emp = (Employee)uow.registerObject((Object)this.createNewEmployeeObject());
        this.manager = (Employee)uow.registerObject((Object)this.createNewManagerObject());
        this.manager.setAddress((Address)uow.registerObject((Object)this.addressExample1()));
        uow.commit();
        uow = this.getSession().acquireUnitOfWork();
        Employee cloneEmp = (Employee)uow.readObject((Object)this.emp);
        ReadObjectQuery roq = new ReadObjectQuery(Employee.class);
        roq.setSelectionCriteria(roq.getExpressionBuilder().get("firstName").equal((Object)this.manager.getFirstName()));
        Employee cloneManager = (Employee)uow.executeQuery((DatabaseQuery)roq);
        cloneEmp.setManager(cloneManager);
        cloneManager.addManagedEmployee(cloneManager);
        uow.commit();
    }

    public void verify() {
    }
}

