/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.simplepojoclient;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.factories.XMLProjectReader;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.simplepojoclient.PojoEmployee;

public class SimplePojoProjectXMLClientTest
extends TestCase {
    private DatabaseSession session = null;
    private SimplePojoProjectXMLClientTest simplePojoProjectXMLClient = null;

    public SimplePojoProjectXMLClientTest() {
        this.setName("SimplePojoProjectXMLClientTest");
    }

    public void setup() throws TestErrorException {
        this.simplePojoProjectXMLClient = new SimplePojoProjectXMLClientTest();
        System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "Now running Simple POJO test using Project Deployment XML file...");
        try {
            Project project = XMLProjectReader.read((String)"PojoEmployee.xml");
            this.session = project.createDatabaseSession();
            this.session.login();
        }
        catch (Exception e) {
            throw new TestErrorException("Session failed to load properly.  Caught: " + e);
        }
    }

    public void test() throws TestErrorException {
        try {
            Vector objects = this.session.readAllObjects(PojoEmployee.class);
            Iterator itr = objects.iterator();
            while (itr.hasNext()) {
                this.simplePojoProjectXMLClient.printObjectAttributes(itr.next());
            }
            System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "Test using Project Deployment XML file is complete" + System.getProperty("line.separator") + System.getProperty("line.separator"));
        }
        catch (Exception e) {
            throw new TestErrorException("" + e);
        }
    }

    private void printObjectAttributes(Object object) throws Exception {
        System.out.println("Object Name: " + object.getClass().getName());
        System.out.println("Fields:");
        Field[] fields = object.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                Field field = fields[i];
                field.setAccessible(true);
                System.out.println("    " + field.getName() + " = " + field.get(object));
                continue;
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
    }
}

