/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionbroker;

import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.OracleDBPlatformHelper;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.sessionbroker.EmployeeProject1;
import org.eclipse.persistence.testing.tests.sessionbroker.EmployeeProject2;

public class Server {
    public SessionBroker sSessionBroker = Server.buildServerBroker();
    public boolean errorOccured;

    public static SessionBroker buildServerBroker() {
        SessionBroker sSessionBroker = new SessionBroker();
        ServerSession ssession1 = new ServerSession((Login)Server.getLogin1());
        ServerSession ssession2 = new ServerSession((Login)Server.getLogin2());
        ssession1.useExclusiveReadConnectionPool(5, 5);
        ssession2.useExclusiveReadConnectionPool(5, 5);
        ssession1.addDescriptors((Project)new EmployeeProject1());
        ssession2.addDescriptors((Project)new EmployeeProject2());
        sSessionBroker.registerSession("broker1", (AbstractSession)ssession1);
        sSessionBroker.registerSession("broker2", (AbstractSession)ssession2);
        ((ManyToManyMapping)ssession1.getDescriptor(Employee.class).getMappingForAttributeName("projects")).setSessionName("broker2");
        ((OneToOneMapping)ssession1.getDescriptor(Employee.class).getMappingForAttributeName("address")).setShouldVerifyDelete(false);
        return sSessionBroker;
    }

    public static DatabaseLogin getLogin1() {
        DatabaseLogin login = new DatabaseLogin();
        try {
            login.usePlatform((DatabasePlatform)OracleDBPlatformHelper.getInstance().getOracle9Platform());
        }
        catch (Exception exception) {
            // empty catch block
        }
        login.useOracleThinJDBCDriver();
        login.setDatabaseURL("ottvm028.ca.oracle.com:1521:toplink");
        login.setUserName("QA7");
        login.setPassword("password");
        login.useNativeSequencing();
        login.getDefaultSequence().setPreallocationSize(1);
        return login;
    }

    public static DatabaseLogin getLogin2() {
        DatabaseLogin login = new DatabaseLogin();
        try {
            login.usePlatform((DatabasePlatform)OracleDBPlatformHelper.getInstance().getOracle9Platform());
        }
        catch (Exception exception) {
            // empty catch block
        }
        login.useOracleThinJDBCDriver();
        login.setDatabaseURL("ottvm028.ca.oracle.com:1521:toplink");
        login.setUserName("QA8");
        login.setPassword("password");
        login.useNativeSequencing();
        login.getDefaultSequence().setPreallocationSize(1);
        return login;
    }

    public void login() {
        this.sSessionBroker.login();
    }

    public void logout() {
        this.sSessionBroker.logout();
    }
}

