/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionbroker;

import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.UniversalSessionTestAdapter;
import org.eclipse.persistence.testing.tests.clientserver.Server;

public class ClientSessionBrokerTestAdapter
extends UniversalSessionTestAdapter {
    protected Server server;

    public ClientSessionBrokerTestAdapter(TestCase wrappedTest) {
        super(wrappedTest);
        this.setName("ClientSessionBroker:" + wrappedTest.getName());
        this.setDescription("On ClientSessionBroker: " + wrappedTest.getDescription());
    }

    public Session setupTestSession(Session oldSession) {
        DatabaseLogin login = (DatabaseLogin)oldSession.getLogin().clone();
        Project project = oldSession.getProject().clone();
        project.setLogin(login);
        this.server = new Server(project);
        this.server.serverSession.setLogLevel(oldSession.getLogLevel());
        this.server.serverSession.setLog(oldSession.getLog());
        this.server.login();
        this.server.copyDescriptors(oldSession);
        SessionBroker broker = new SessionBroker();
        broker.registerSession("serverSession", (Session)this.server.serverSession);
        return broker.acquireClientSessionBroker();
    }

    public void tearDownTestSession(Session testSession) {
        testSession.release();
        this.server.logout();
    }
}

