/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.returning.model;

import junit.framework.Test;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.tests.returning.model.Class1;
import org.eclipse.persistence.testing.tests.returning.model.Class2;
import org.eclipse.persistence.testing.tests.returning.model.ReturnObjectControl;
import org.eclipse.persistence.testing.tests.returning.model.ReturningInsertTestCase;
import org.eclipse.persistence.testing.tests.returning.model.ReturningTestSystem;
import org.eclipse.persistence.testing.tests.returning.model.ReturningUpdateTestCase;

public class ReturningMappingsTestModel
extends TestModel {
    ReturnObjectControl returnObjectControl;

    public ReturningMappingsTestModel() {
        this.setDescription("This model tests ReturningPolicy with various mapping.");
    }

    public ReturningMappingsTestModel(ReturnObjectControl returnObjectControl) {
        this();
        this.returnObjectControl = returnObjectControl;
    }

    public void addRequiredSystems() {
        if (!this.getSession().getPlatform().isOracle()) {
            throw new TestWarningException("ReturningMappingsTestModel runs on Oracle only.");
        }
        this.addRequiredSystem(new ReturningTestSystem());
    }

    public void addTests() {
        this.addTest((Test)this.getTestSuite());
    }

    protected TestSuite getTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("Mappings Test Suite");
        suite.addTest((Test)new ReturningInsertTestCase(new Class1(), false, this.returnObjectControl));
        suite.addTest((Test)new ReturningInsertTestCase(new Class1(), true, this.returnObjectControl));
        suite.addTest((Test)new ReturningInsertTestCase(new Class1(2.0, 1.0, new Class2(2.0, 1.0)), false, this.returnObjectControl));
        suite.addTest((Test)new ReturningInsertTestCase(new Class1(2.0, 1.0, new Class2(2.0, 1.0)), true, this.returnObjectControl));
        suite.addTest((Test)new ReturningUpdateTestCase(new Class1(), new Class1(2.0, 1.0, new Class2(2.0, 1.0)), false, this.returnObjectControl));
        suite.addTest((Test)new ReturningUpdateTestCase(new Class1(), new Class1(2.0, 1.0, new Class2(2.0, 1.0)), true, this.returnObjectControl));
        suite.addTest((Test)new ReturningUpdateTestCase(new Class1(2.0, 1.0, new Class2(2.0, 1.0)), new Class1(), false, this.returnObjectControl));
        suite.addTest((Test)new ReturningUpdateTestCase(new Class1(2.0, 1.0, new Class2(2.0, 1.0)), new Class1(), true, this.returnObjectControl));
        return suite;
    }
}

