/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.remote;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.remote.RemoteModel;

public class RefreshCascadeNonPrivateTest
extends TestCase {
    protected Employee employee;
    protected Employee r_employee;
    protected String originalFirstName;

    public RefreshCascadeNonPrivateTest() {
        this.setDescription("Tests if remote refresh cascades no-private parts correctly.");
    }

    public void reset() {
        ((AbstractSession)RemoteModel.getServerSession()).rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        ((AbstractSession)RemoteModel.getServerSession()).beginTransaction();
    }

    public void test() throws Exception {
        UnitOfWork uow = RemoteModel.getServerSession().acquireUnitOfWork();
        this.employee = (Employee)uow.readObject(Employee.class, new ExpressionBuilder().get("manager").notEqual(null));
        this.originalFirstName = this.employee.getManager().getFirstName();
        this.employee.setManager(new Employee());
        uow.commit();
        this.r_employee = (Employee)this.getSession().refreshObject((Object)this.employee);
    }

    public void verify() throws Exception {
        if (this.originalFirstName.equals(this.r_employee.getManager().getFirstName())) {
            throw new TestErrorException("Remote refresh didn't cascade non-private parts correctly.");
        }
    }
}

