/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.readonly;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.readonly.Address;
import org.eclipse.persistence.testing.models.readonly.Country;

public class ReadOnlyDescriptorInsertTestCase
extends AutoVerifyTestCase {
    Address address;

    protected void setup() {
        this.beginTransaction();
    }

    public void reset() {
        this.getSession().getProject().setDefaultReadOnlyClasses(new Vector());
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    protected void test() {
        Country count = (Country)this.getSession().readObject(Country.class);
        this.getSession().getDescriptor((Object)count).setReadOnly();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.address = new Address();
        Address addressClone = (Address)uow.registerObject((Object)this.address);
        addressClone.setStreetAddress("21D Water Street");
        addressClone.setCity("Perth");
        addressClone.setZipCode("K2C 5B6");
        addressClone.setCountry(count);
        uow.commit();
    }

    protected void verify() {
        this.getSession().getIdentityMapAccessor().removeFromIdentityMap((Object)this.address);
        ExpressionBuilder expBuilder = new ExpressionBuilder();
        Expression exp = expBuilder.get("streetAddress").equal((Object)this.address.getStreet());
        Address dbAddress = (Address)this.getSession().readObject(Address.class, exp);
        if (!this.address.equals(dbAddress)) {
            throw new TestErrorException("The read-only flag set on the descriptor does not work!");
        }
    }
}

