/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.oracle;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.models.mapping.Employee;
import org.eclipse.persistence.testing.tests.queries.oracle.HierarchicalQueryTest;

public class OrderSiblingsTest
extends HierarchicalQueryTest {
    private Vector expected;

    public OrderSiblingsTest() {
        this.setName("OrderSiblingsTest");
        this.setDescription("Tests the use of the Order Siblings Clause");
    }

    @Override
    public Vector expectedResults() {
        if (this.expected == null) {
            this.expected = new Vector();
            ExpressionBuilder expb = new ExpressionBuilder();
            Employee daveVadis = (Employee)this.getSession().readObject(Employee.class, expb.get("lastName").equal((Object)"Vadis"));
            Employee edwardWhite = (Employee)this.getSession().readObject(Employee.class, expb.get("lastName").equal((Object)"White"));
            Employee tracyChapman = (Employee)this.getSession().readObject(Employee.class, expb.get("lastName").equal((Object)"Chapman"));
            this.expected.addElement(daveVadis);
            this.addEmployee(this.expected, edwardWhite);
            this.addEmployee(this.expected, tracyChapman);
        }
        return this.expected;
    }

    @Override
    public ReadAllQuery getQuery() {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        ExpressionBuilder expb = new ExpressionBuilder();
        Expression startWith = expb.get("firstName").equal((Object)"Dave").and(expb.get("lastName").equal((Object)"Vadis"));
        Expression connectBy = expb.get("managedEmployees");
        Vector<Expression> order = new Vector<Expression>();
        order.addElement(expb.get("firstName"));
        query.setHierarchicalQueryClause(startWith, connectBy, order);
        return query;
    }
}

