/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.optimization;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.testing.framework.ReadAllTest;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;

public class ReadAllPartialReadingTest
extends ReadAllTest {
    public String attribute;

    public ReadAllPartialReadingTest(int size, String attribute) {
        super(Employee.class, size);
        this.setName("PartialReadingTest" + attribute);
        this.attribute = attribute;
    }

    protected void setup() {
        super.setup();
    }

    protected void verify() throws Exception {
        super.verify();
        ContainerPolicy cp = this.getQuery().getContainerPolicy();
        if (cp.isCursorPolicy()) {
            Enumeration enumtr = ((Vector)this.objectsFromDatabase).elements();
            while (enumtr.hasMoreElements()) {
                this.verifyEmployee((Employee)enumtr.nextElement());
            }
        } else {
            Object iter = cp.iteratorFor(this.objectsFromDatabase);
            while (cp.hasNext(iter)) {
                this.verifyEmployee((Employee)cp.next(iter, this.getAbstractSession()));
            }
        }
    }

    protected void verifyEmployee(Employee employee) {
        if (!employee.getLastName().equals("")) {
            throw new TestErrorException("last name was read.");
        }
        if (this.attribute.equals("firstName") && employee.getFirstName().equals("")) {
            throw new TestErrorException("first name was not read.");
        }
        if (this.attribute.equals("address") && employee.getAddress() == null) {
            throw new TestErrorException("address was not read.");
        }
        if (this.attribute.equals("address") && employee.getPeriod() == null) {
            throw new TestErrorException("period was not read.");
        }
        if (this.attribute.equals("address") && employee.getAddress().getCity() == null) {
            throw new TestErrorException("city was not read.");
        }
        if (this.attribute.equals("address") && employee.getPeriod().getStartDate() == null) {
            throw new TestErrorException("start date was not read.");
        }
        if (this.attribute.equals("city") && employee.getAddress() == null) {
            throw new TestErrorException("address was not read.");
        }
        if (this.attribute.equals("city") && employee.getAddress().getCity() == "") {
            throw new TestErrorException("address city was not read.");
        }
        if (this.attribute.equals("city") && employee.getAddress().getCountry() != "") {
            throw new TestErrorException("address country was read.");
        }
        if (this.attribute.equals("areaCode")) {
            if (!employee.phoneNumbers.isInstantiated()) {
                throw new TestErrorException("phone value holder not instantiated.");
            }
            if (((PhoneNumber)employee.getPhoneNumbers().get(0)).getAreaCode() == "") {
                throw new TestErrorException("phone area-code was not read.");
            }
        }
    }
}

