/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.optimization;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.vehicle.CarOwner;

public class MultipleJoinedAttributeQueryTest
extends TestCase {
    private CarOwner owner = null;

    public MultipleJoinedAttributeQueryTest() {
        this.setDescription("Test select list with multiple joined attributes specified in an order.");
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        ReadObjectQuery query = new ReadObjectQuery(CarOwner.class);
        ExpressionBuilder rootExpression = query.getExpressionBuilder();
        Expression expression = rootExpression.getAllowingNull("car");
        query.addJoinedAttribute(expression);
        expression = expression.getAllowingNull("engineType");
        query.addJoinedAttribute(expression);
        expression = rootExpression.getAllowingNull("lastCar");
        query.addJoinedAttribute(expression);
        expression = expression.get("fuelType");
        query.addJoinedAttribute(expression);
        expression = rootExpression.getAllowingNull("car");
        query.addJoinedAttribute(expression);
        expression = expression.get("fuelType");
        query.addJoinedAttribute(expression);
        this.owner = (CarOwner)uow.executeQuery((DatabaseQuery)query);
    }

    public void verify() {
        if (this.owner == null || this.owner.getCar() == null || this.owner.getCar().getFuelType() == null) {
            throw new TestErrorException("CarOwner or Car or FuelType is not found.");
        }
        if (!this.owner.getCar().getFuelType().getFuelDescription().equals("Petrol")) {
            throw new TestErrorException("Car Fuel Type is expected to be Petrol, but found " + this.owner.getCar().getFuelType().getFuelDescription());
        }
    }
}

