/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.InMemoryQueryIndirectionPolicy;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.Project;

public class ConformingShouldTriggerIndirectionTest
extends AutoVerifyTestCase {
    public void test() throws Exception {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        ExpressionBuilder proj = new ExpressionBuilder();
        Expression outOfOttawaProjectsExp = proj.get("teamLeader").get("address").get("city").notEqual((Object)"Ottawa");
        ReadAllQuery originalQuery = new ReadAllQuery(Project.class);
        originalQuery.setSelectionCriteria(outOfOttawaProjectsExp);
        Vector outOfOttawaProjects = (Vector)uow.executeQuery((DatabaseQuery)originalQuery);
        ExpressionBuilder emp = new ExpressionBuilder();
        Expression ottawaEmpsExp = emp.get("address").get("city").equal((Object)"Ottawa");
        ReadAllQuery employeeQuery = new ReadAllQuery(Employee.class);
        employeeQuery.setSelectionCriteria(ottawaEmpsExp);
        Vector ottawaEmps = (Vector)uow.executeQuery((DatabaseQuery)employeeQuery);
        Project conformingProject = (Project)outOfOttawaProjects.elementAt(0);
        Employee conformingEmp = (Employee)ottawaEmps.elementAt(0);
        conformingProject.setTeamLeader(conformingEmp);
        ReadAllQuery conformingQuery = originalQuery;
        conformingQuery.setInMemoryQueryIndirectionPolicy(new InMemoryQueryIndirectionPolicy(1));
        conformingQuery.conformResultsInUnitOfWork();
        Vector conformingProjects = (Vector)uow.executeQuery((DatabaseQuery)conformingQuery);
        if (conformingProjects.size() + 1 != outOfOttawaProjects.size()) {
            throw new TestErrorException("The result was not conformed.  Original: " + outOfOttawaProjects + " Conforming: " + conformingProjects);
        }
    }
}

