/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.reading;

import java.util.List;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.performance.toplink.Employee;

public class ReadAllvsConformNewUnitOfWorkTest
extends PerformanceComparisonTestCase {
    protected List allObjects;

    public ReadAllvsConformNewUnitOfWorkTest() {
        this.setDescription("This test compares the performance of read all in unit of work vs conform read all.");
        this.addReadAllConformTest();
    }

    public void setup() {
        this.allObjects = this.getSession().readAllObjects(Employee.class);
    }

    public void test() throws Exception {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        query.setSelectionCriteria(builder.get("salary").greaterThan(0));
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        List results = (List)uow.executeQuery((DatabaseQuery)query);
    }

    public void addReadAllConformTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                ReadAllQuery query = new ReadAllQuery(Employee.class);
                ExpressionBuilder builder = new ExpressionBuilder();
                query.setSelectionCriteria(builder.get("salary").greaterThan(0));
                query.conformResultsInUnitOfWork();
                UnitOfWork uow = this.getSession().acquireUnitOfWork();
                List results = (List)uow.executeQuery((DatabaseQuery)query);
            }
        };
        test.setName("ReadAllConformTest");
        test.setAllowableDecrease(-5.0);
        this.addTest((TestCase)test);
    }

    public void verify() {
        try {
            super.verify();
        }
        catch (TestErrorException slow) {
            throw new TestWarningException("Conforming in a new unit of work should not conform known bug 3602166");
        }
    }
}

