/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.java;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;

public class ForLoopTest
extends PerformanceComparisonTestCase {
    public Vector list;
    public List arrayList;

    public ForLoopTest() {
        this.setName("ForLoop vs Enumeration PerformanceComparisonTest");
        this.setDescription("This test compares the performance of index for loops vs enumeration/iterators.");
        this.addIndexArrayListTest();
        this.addEnumeratorTest();
        this.addIteratorTest();
        this.addIteratorArrayListTest();
        this.addForTest();
        this.addForArrayListTest();
        this.list = new Vector();
        this.arrayList = new ArrayList();
        for (int index = 0; index < 100; ++index) {
            this.list.add(new Object());
            this.arrayList.add(new Object());
        }
    }

    public void test() throws Exception {
        int size = this.list.size();
        for (int index = 0; index < size; ++index) {
            Object object = this.list.get(index);
            object.hashCode();
        }
    }

    public void addEnumeratorTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                Enumeration enumtr = ForLoopTest.this.list.elements();
                while (enumtr.hasMoreElements()) {
                    Object object = enumtr.nextElement();
                    object.hashCode();
                }
            }
        };
        test.setName("EnumerationTest");
        test.setAllowableDecrease(-10.0);
        this.addTest((TestCase)test);
    }

    public void addIteratorTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                for (Object object : ForLoopTest.this.list) {
                    object.hashCode();
                }
            }
        };
        test.setName("IteratorTest");
        test.setAllowableDecrease(-70.0);
        this.addTest((TestCase)test);
    }

    public void addIteratorArrayListTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                for (Object object : ForLoopTest.this.arrayList) {
                    object.hashCode();
                }
            }
        };
        test.setName("ArrayListIteratorTest");
        test.setAllowableDecrease(-70.0);
        this.addTest((TestCase)test);
    }

    public void addForArrayListTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                for (Object object : ForLoopTest.this.arrayList) {
                    object.hashCode();
                }
            }
        };
        test.setName("ForArrayListTest");
        test.setAllowableDecrease(-70.0);
        this.addTest((TestCase)test);
    }

    public void addForTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                for (Object object : ForLoopTest.this.list) {
                    object.hashCode();
                }
            }
        };
        test.setName("ForTest");
        test.setAllowableDecrease(-70.0);
        this.addTest((TestCase)test);
    }

    public void addIndexArrayListTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                int size = ForLoopTest.this.arrayList.size();
                for (int index = 0; index < size; ++index) {
                    Object object = ForLoopTest.this.arrayList.get(index);
                    object.hashCode();
                }
            }
        };
        test.setName("IndexArrayListTest");
        test.setAllowableDecrease(-70.0);
        this.addTest((TestCase)test);
    }
}

