/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimisticlocking;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class WriteLockValueSerializationTest
extends AutoVerifyTestCase {
    public boolean serializationError = true;

    public WriteLockValueSerializationTest() {
        this.setDescription("Ensure the hasVersionChange variable is not always set when ObjectChangeSet is serialized.");
    }

    public void setup() {
        this.serializationError = false;
    }

    public void test() {
        ObjectChangeSet changeSet = new ObjectChangeSet();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(changeSet);
            oos.flush();
            byte[] bytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            changeSet = (ObjectChangeSet)ois.readObject();
        }
        catch (IOException exception) {
            throw new TestErrorException("The change set did not serialize properly. IOException:" + exception.toString());
        }
        catch (ClassNotFoundException exception) {
            throw new TestErrorException("The change set did not serialize properly. ClassNotFoundException:" + exception.toString());
        }
        if (changeSet.hasChanges()) {
            this.serializationError = true;
        }
    }

    public void verify() {
        if (this.serializationError) {
            throw new TestErrorException("Object Change set returns true for hasChanges after serialization even though there are not changes.");
        }
    }
}

