/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimisticlocking;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.descriptors.AllFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.ChangedFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.descriptors.SelectedFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.TimestampLockingPolicy;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.optimisticlocking.AbstractVideogameObject;

public class SwitchableOptimisticLockingPolicyTest
extends TestCase {
    protected Exception tlException;
    protected Class optimisticLockingPolicyClass;
    protected Map<Class, OptimisticLockingPolicy> oldOptimisticLockingPolicies;

    public SwitchableOptimisticLockingPolicyTest(Class optimisticLockingPolicyClass) {
        this.setName(this.getName() + " (" + Helper.getShortClassName((Class)optimisticLockingPolicyClass) + ")");
        this.optimisticLockingPolicyClass = optimisticLockingPolicyClass;
        this.oldOptimisticLockingPolicies = new HashMap<Class, OptimisticLockingPolicy>();
    }

    public void setup() {
        Set<Class> keys = this.getOldOptimisticLockingPolicies().keySet();
        for (Class classToModify : new ArrayList<Class>(keys)) {
            if (!AbstractVideogameObject.class.isAssignableFrom(classToModify)) {
                this.throwError(classToModify.getName() + " does not implement " + AbstractVideogameObject.class.getName());
            }
            if (!OptimisticLockingPolicy.class.isAssignableFrom(this.getOptimisticLockingPolicyClass())) {
                this.throwError(this.getOptimisticLockingPolicyClass().getName() + " does not implement " + OptimisticLockingPolicy.class.getName());
            }
            ClassDescriptor descriptor = this.getSession().getDescriptor(classToModify);
            this.getOldOptimisticLockingPolicies().put(classToModify, descriptor.getOptimisticLockingPolicy());
            AbstractVideogameObject instance = (AbstractVideogameObject)Helper.getInstanceFromClass((Class)classToModify);
            if (this.getOptimisticLockingPolicyClass() == ChangedFieldsLockingPolicy.class) {
                instance.configureChangedFieldsLockingOn(descriptor);
            } else if (this.getOptimisticLockingPolicyClass() == AllFieldsLockingPolicy.class) {
                instance.configureAllFieldsLockingOn(descriptor);
            } else if (this.getOptimisticLockingPolicyClass() == VersionLockingPolicy.class) {
                instance.configureVersionLockingOn(descriptor);
            } else if (this.getOptimisticLockingPolicyClass() == SelectedFieldsLockingPolicy.class) {
                instance.configureSelectedFieldsLockingOn(descriptor);
            } else if (this.getOptimisticLockingPolicyClass() == TimestampLockingPolicy.class) {
                instance.configureTimestampLockingOn(descriptor);
            } else {
                this.throwError("Invalid optimistic locking policy " + this.getOptimisticLockingPolicyClass().getName());
            }
            descriptor.getOptimisticLockingPolicy().initialize((AbstractSession)this.getSession());
            descriptor.setQueryManager(new DescriptorQueryManager());
            descriptor.getQueryManager().initialize((AbstractSession)this.getSession());
        }
    }

    public void deleteObject(Object object) {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.deleteObject(uow.readObject(object));
        uow.commit();
    }

    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        if (this.tlException != null) {
            this.throwError("An exception occurred updating the object on the DB: ", this.tlException);
        }
    }

    public void reset() {
        Set<Class> keys = this.getOldOptimisticLockingPolicies().keySet();
        for (Class classToModify : new ArrayList<Class>(keys)) {
            ClassDescriptor descriptor = this.getSession().getDescriptor(classToModify);
            OptimisticLockingPolicy oldOptimisticLockingPolicy = this.getOldOptimisticLockingPolicies().get(classToModify);
            descriptor.setOptimisticLockingPolicy(oldOptimisticLockingPolicy);
            if (descriptor.getOptimisticLockingPolicy() != null) {
                descriptor.getOptimisticLockingPolicy().initialize((AbstractSession)this.getSession());
            }
            descriptor.setQueryManager(new DescriptorQueryManager());
            descriptor.getQueryManager().initialize((AbstractSession)this.getSession());
        }
        this.tlException = null;
        this.oldOptimisticLockingPolicies.clear();
    }

    public void addClassToModify(Class clazz) {
        this.getOldOptimisticLockingPolicies().put(clazz, null);
    }

    public Class getOptimisticLockingPolicyClass() {
        return this.optimisticLockingPolicyClass;
    }

    public void setOptimisticLockingPolicyClass(Class optimisticLockingPolicyClass) {
        this.optimisticLockingPolicyClass = optimisticLockingPolicyClass;
    }

    public Map<Class, OptimisticLockingPolicy> getOldOptimisticLockingPolicies() {
        return this.oldOptimisticLockingPolicies;
    }

    public void setOldOptimisticLockingPolicies(Map<Class, OptimisticLockingPolicy> oldOptimisticLockingPolicy) {
        this.oldOptimisticLockingPolicies = oldOptimisticLockingPolicy;
    }
}

