/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.mapping;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.DeleteObjectTest;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.mapping.Employee;
import org.eclipse.persistence.testing.models.mapping.Shipment;

public class Public1MTest
extends DeleteObjectTest {
    Employee employeeBeingDeleted;
    Vector managedEmployees;
    Vector shipments;
    Employee manager;
    public UnitOfWork unitOfWork;

    public Public1MTest(Object originalObject) {
        super(originalObject);
    }

    public void reset() {
        super.reset();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    protected void setup() {
        super.setup();
        this.unitOfWork = this.getSession().acquireUnitOfWork();
        this.employeeBeingDeleted = (Employee)this.unitOfWork.registerObject(this.originalObject);
        this.managedEmployees = this.employeeBeingDeleted.getManagedEmployees();
        this.shipments = this.employeeBeingDeleted.getShipments();
        this.manager = this.employeeBeingDeleted.getManager();
        if (this.manager != null) {
            this.manager.removeManagedEmployee(this.employeeBeingDeleted);
        }
        Enumeration employeeEnum = this.managedEmployees.elements();
        while (employeeEnum.hasMoreElements()) {
            ((Employee)employeeEnum.nextElement()).setManager(null);
        }
        Enumeration shipmentEnum = this.shipments.elements();
        while (shipmentEnum.hasMoreElements()) {
            ((Shipment)shipmentEnum.nextElement()).removeEmployee(this.employeeBeingDeleted);
        }
    }

    protected void test() {
        this.unitOfWork.deleteObject((Object)this.employeeBeingDeleted);
        this.unitOfWork.commit();
    }

    protected void verify() {
        Enumeration enumtr = this.managedEmployees.elements();
        while (enumtr.hasMoreElements()) {
            if (!this.verifyDelete(enumtr.nextElement())) continue;
            throw new TestErrorException("Public parts were deleted along with " + this.employeeBeingDeleted);
        }
    }
}

